/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.config.ingame.JSGEnumConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.screen.element.ModeButton;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabScrollAble;
import dev.tauri.jsg.screen.util.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;

public class TabConfig
extends TabScrollAble {
    private final List<AbstractWidget> modifiers = new ArrayList<AbstractWidget>();
    public JSGTileEntityConfig config;
    private Runnable onTabClose = null;

    protected TabConfig(TabConfigBuilder builder) {
        super(builder);
        this.config = builder.config;
        this.updateConfig(builder.config, true);
    }

    public static TabConfigBuilder builder() {
        return new TabConfigBuilder();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        super.render(graphics, mouseX, mouseY);
        this.updateConfig(null, false);
        for (int id = 0; id < this.modifiers.size(); ++id) {
            AbstractWidget modifier = this.modifiers.get(id);
            int x = modifier.m_252754_();
            int y = modifier.m_252907_() - 9;
            if (modifier instanceof EditBox) {
                EditBox field = (EditBox)modifier;
                if (!this.canRenderEntry(x, y)) continue;
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.config.getOption(id).getLabel(), x, y, 0x404040, false);
                field.m_88315_(graphics, mouseX, mouseY, 0.0f);
                continue;
            }
            if (!(modifier instanceof ModeButton)) continue;
            ModeButton button = (ModeButton)modifier;
            if (!this.canRenderEntry(x, y)) continue;
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.config.getOption(id).getLabel(), x, y, 0x404040, false);
            button.drawButton(graphics, mouseX, mouseY);
        }
        this.renderCover(graphics);
    }

    @Override
    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderFg(graphics, mouseX, mouseY);
        if (this.isVisible() && this.isOpen()) {
            for (int id = 0; id < this.modifiers.size(); ++id) {
                AbstractWidget modifier = this.modifiers.get(id);
                int x = modifier.m_252754_();
                int y = modifier.m_252907_() - 9;
                if (modifier instanceof EditBox) {
                    EditBox field = (EditBox)modifier;
                    if (this.canRenderEntry(x, y) && GuiHelper.isPointInRegion(x, y, field.m_5711_(), 10 + field.m_93694_(), mouseX, mouseY)) {
                        graphics.m_280677_(Minecraft.m_91087_().f_91062_, this.config.getOption(id).getCommentToRender(), Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
                    }
                }
                if (!(modifier instanceof ModeButton)) continue;
                ModeButton button = (ModeButton)modifier;
                if (!this.canRenderEntry(x, y) || !GuiHelper.isPointInRegion(x, y, 75, 10 + button.m_93694_(), mouseX, mouseY)) continue;
                graphics.m_280677_(Minecraft.m_91087_().f_91062_, this.config.getOption(id).getCommentToRender(), Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    @Override
    public boolean canContinueScrolling(int k) {
        int top = this.guiTop + this.defaultY + 30;
        int bottom = this.guiTop + this.defaultY + this.height - 38;
        if (this.modifiers.isEmpty()) {
            return false;
        }
        boolean isTop = this.modifiers.get(0).m_252907_() > top;
        boolean isBottom = this.modifiers.get(this.modifiers.size() - 1).m_252907_() < bottom;
        return !isTop && k == 1 || !isBottom && k == -1;
    }

    @Override
    public boolean canRenderEntry(int x, int y) {
        int top = this.guiTop + this.defaultY + 3;
        int bottom = this.guiTop + this.defaultY + this.height;
        int height = this.modifiers.parallelStream().mapToInt(AbstractWidget::m_93694_).max().orElse(16);
        return y >= top && y + height <= bottom - 12;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.modifiers.stream().filter(m -> m instanceof EditBox).map(m -> (EditBox)m).forEach(field -> field.m_6375_((double)mouseX, (double)mouseY, mouseButton));
        this.modifiers.parallelStream().mapMulti((m, cons) -> {
            if (m instanceof ModeButton) {
                ModeButton mb = (ModeButton)((Object)m);
                cons.accept(mb);
            }
        }).forEach(button -> {
            if (GuiHelper.isPointInRegion(button.m_252754_(), button.m_252907_(), button.m_5711_(), button.m_93694_(), mouseX, mouseY)) {
                switch (mouseButton) {
                    case 0: {
                        button.nextState();
                        break;
                    }
                    case 1: {
                        button.previousState();
                    }
                }
                button.m_7435_(Minecraft.m_91087_().m_91106_());
            }
        });
        this.getConfig(true);
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        boolean typed = this.modifiers.stream().filter(m -> m instanceof EditBox).map(m -> (EditBox)m).anyMatch(field -> field.m_7933_((int)typedChar, keyCode, 0));
        this.getConfig(true);
        return typed;
    }

    @Override
    public boolean charTyped(char character, int intChar) {
        boolean typed = this.modifiers.stream().filter(m -> m instanceof EditBox).map(m -> (EditBox)m).anyMatch(field -> field.m_5534_(character, intChar));
        this.getConfig(true);
        return typed;
    }

    public void setOnTabClose(Runnable onTabClose) {
        this.onTabClose = onTabClose;
    }

    @Override
    public void closeTab() {
        if (this.onTabClose != null) {
            this.onTabClose.run();
        }
        super.closeTab();
    }

    public JSGTileEntityConfig getConfig(boolean saveValues) {
        if (saveValues) {
            for (int id = 0; id < this.modifiers.size(); ++id) {
                AbstractWidget abstractWidget = this.modifiers.get(id);
                if (abstractWidget instanceof EditBox) {
                    EditBox field = (EditBox)abstractWidget;
                    this.config.getOption(id).setValue(field.m_94155_());
                    continue;
                }
                abstractWidget = this.modifiers.get(id);
                if (!(abstractWidget instanceof ModeButton)) continue;
                ModeButton button = (ModeButton)abstractWidget;
                JSGConfigOption<?> option = this.config.getOption(id);
                if (option instanceof JSGEnumConfigOption) {
                    JSGEnumConfigOption enOpt = (JSGEnumConfigOption)option;
                    enOpt.setValue(String.valueOf(enOpt.allowedValues.get(button.getCurrentState())));
                    continue;
                }
                this.config.getOption(id).setValue("" + button.getCurrentState());
            }
        }
        return this.config;
    }

    public void updateConfig(JSGTileEntityConfig config, boolean resetFields) {
        block4: {
            int k;
            block3: {
                if (config != null) {
                    this.config = config;
                }
                k = this.guiTop + this.defaultY + 34;
                if (!resetFields) break block3;
                this.modifiers.clear();
                if (config == null) break block4;
                for (int id = 0; id < config.getOptions().size(); ++id) {
                    Optional.ofNullable(config.getOption(id).createGUIComponent(k, id)).ifPresent(this.modifiers::add);
                }
                break block4;
            }
            for (int id = 0; id < this.modifiers.size(); ++id) {
                AbstractWidget modifier = this.modifiers.get(id);
                modifier.m_253211_(29 * id + k + this.scrolled);
                modifier.m_252865_(this.guiLeft + 6 + this.currentOffsetX + 25);
            }
        }
    }

    public static class TabConfigBuilder
    extends Tab.TabBuilder {
        private JSGTileEntityConfig config;

        public TabConfigBuilder setConfig(JSGTileEntityConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public TabConfig build() {
            return new TabConfig(this);
        }
    }
}

