/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.screen.element.ModeButton;
import dev.tauri.jsg.screen.element.NumberOnlyTextField;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.stargate.EnumIrisMode;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TabIris
extends Tab {
    protected static final ResourceLocation MODES_ICONS = new ResourceLocation("jsg", "textures/gui/iris_mode.png");
    protected NumberOnlyTextField inputField;
    public String code;
    public EnumIrisMode irisMode;
    protected ModeButton buttonChangeMode;
    protected boolean isUniverse;
    private Runnable onTabClose;

    protected TabIris(TabIrisBuilder builder) {
        super(builder);
        this.inputField = new NumberOnlyTextField(this.guiLeft + 6, this.guiTop + this.defaultY + 25, 64, 16);
        this.buttonChangeMode = new ModeButton(1, this.inputField.m_252754_() + this.inputField.m_5711_() + 5, this.guiTop + this.defaultY + 25, 16, MODES_ICONS, 80, 32, 5);
        this.onTabClose = null;
        this.irisMode = builder.irisMode;
        this.isUniverse = builder.isUniverse;
        this.code = builder.code;
        this.buttonChangeMode.setCurrentState(this.irisMode.id);
        this.inputField.m_94199_((Integer)JSGConfig.Stargate.irisCodeLength.get());
        this.inputField.m_94144_(this.code);
        this.inputField.setEnabled(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
    }

    public void updateValue(EnumIrisMode irisMode) {
        this.buttonChangeMode.setCurrentState(irisMode.id);
        this.inputField.setEnabled(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
    }

    public void updateValue(String irisCode) {
        this.inputField.m_94144_(irisCode);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        super.render(graphics, mouseX, mouseY);
        this.buttonChangeMode.m_252865_(this.guiLeft + this.currentOffsetX + 64 + 11);
        this.buttonChangeMode.drawButton(graphics, mouseX, mouseY);
        this.inputField.m_252865_(this.guiLeft + 6 + this.currentOffsetX);
        this.inputField.m_88315_(graphics, mouseX, mouseY, 0.0f);
    }

    @Override
    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderFg(graphics, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && GuiHelper.isPointInRegion(this.buttonChangeMode.m_252754_(), this.buttonChangeMode.m_252907_(), this.buttonChangeMode.m_5711_(), this.buttonChangeMode.m_93694_(), mouseX, mouseY)) {
            ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
            text.add(Component.m_237113_((String)(Component.m_237115_((String)"gui.stargate.iris.help_title").getString() + " " + Component.m_237115_((String)("gui.stargate.iris." + this.getIrisMode().name().toLowerCase())).getString())));
            text.add(Component.m_237115_((String)("gui.stargate.iris." + this.getIrisMode().name().toLowerCase() + "_help")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            if (this.buttonChangeMode.getCurrentState() == 2) {
                text.add(Component.m_237115_((String)"gui.stargate.iris.auto1_help").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            }
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, text, Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public static TabIrisBuilder builder() {
        return new TabIrisBuilder();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.inputField.m_6375_(mouseX, mouseY, mouseButton);
        if (GuiHelper.isPointInRegion(this.buttonChangeMode.m_252754_(), this.buttonChangeMode.m_252907_(), this.buttonChangeMode.m_5711_(), this.buttonChangeMode.m_93694_(), mouseX, mouseY)) {
            switch (mouseButton) {
                case 0: {
                    this.buttonChangeMode.nextState();
                    if (this.isUniverse || this.buttonChangeMode.getCurrentState() != 4) break;
                    this.buttonChangeMode.nextState();
                    break;
                }
                case 1: {
                    this.buttonChangeMode.previousState();
                    if (this.isUniverse || this.buttonChangeMode.getCurrentState() != 4) break;
                    this.buttonChangeMode.previousState();
                    break;
                }
                case 2: {
                    this.buttonChangeMode.setCurrentState(0);
                }
            }
            this.inputField.setEnabled(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
            this.buttonChangeMode.m_7435_(Minecraft.m_91087_().m_91106_());
        }
    }

    public EnumIrisMode getIrisMode() {
        return EnumIrisMode.getValue((byte)this.buttonChangeMode.getCurrentState());
    }

    public String getCode() {
        return !this.inputField.m_94155_().isEmpty() ? this.inputField.m_94155_() : "";
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        return this.inputField.m_7933_(typedChar, keyCode, 0);
    }

    @Override
    public boolean charTyped(char character, int intChar) {
        return this.inputField.m_5534_(character, intChar);
    }

    public void setOnTabClose(Runnable onTabClose) {
        this.onTabClose = onTabClose;
    }

    @Override
    public void closeTab() {
        if (this.onTabClose != null) {
            this.onTabClose.run();
        }
        super.closeTab();
    }

    public static class TabIrisBuilder
    extends Tab.TabBuilder {
        private EnumIrisMode irisMode = EnumIrisMode.OPENED;
        private String code = "";
        private boolean isUniverse = false;

        public TabIrisBuilder setCode(String code) {
            this.code = code;
            return this;
        }

        public TabIrisBuilder setIsUniverse(boolean is) {
            this.isUniverse = is;
            return this;
        }

        public TabIrisBuilder setIrisMode(EnumIrisMode irisMode) {
            this.irisMode = irisMode;
            return this;
        }

        @Override
        public TabIris build() {
            return new TabIris(this);
        }
    }
}

