/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.util.GuiHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class JSGTexturedGui
extends Screen {
    public int guiLeft;
    public int guiTop;
    public GuiGraphics graphics;
    public PoseStack stack;
    public final int xSize;
    public final int ySize;
    protected final int texW;
    protected final int texH;

    public JSGTexturedGui(String name, int sizeX, int sizeY) {
        this(name, sizeX, sizeY, 256, 256);
    }

    public JSGTexturedGui(String name, int sizeX, int sizeY, int texW, int texH) {
        super((Component)Component.m_237113_((String)name));
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.texW = texW;
        this.texH = texH;
    }

    public abstract ResourceLocation getBackground();

    public void drawBackground() {
        GuiHelper.renderTransparentBackground(this.graphics, this);
        Texture.bindTextureWithMc(this.getBackground());
        GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, this.texW, this.texH);
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
    }

    public abstract void drawForeground(int var1, int var2, float var3);

    public void drawButtons(int mouseX, int mouseY, float partialTicks) {
    }

    public void onGraphicsSet(GuiGraphics graphics) {
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.graphics = graphics;
        GuiHelper.currentStack = graphics.m_280168_();
        this.onGraphicsSet(graphics);
        this.stack = graphics.m_280168_();
        this.drawBackground();
        this.drawButtons(mouseX, mouseY, partialTicks);
        this.stack.m_85836_();
        this.stack.m_252880_((float)this.guiLeft, (float)this.guiTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawForeground(mouseX, mouseY, partialTicks);
        this.stack.m_85849_();
    }
}

