/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.helpers.JSGMinecraftHelper;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.base.JSGButtonClassic;
import dev.tauri.jsg.screen.element.IconButton;
import dev.tauri.jsg.screen.gui.mainmenu.EnumMainMenuGateType;
import dev.tauri.jsg.screen.gui.mainmenu.EnumMainMenuTips;
import dev.tauri.jsg.screen.gui.mainmenu.MainMenuNotifications;
import dev.tauri.jsg.screen.util.GuiHelper;
import dev.tauri.jsg.sound.FlybySoundInstance;
import dev.tauri.jsg.sound.JSGSoundHelperClient;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.util.updater.GetUpdate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ModListScreen;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuiCustomMainMenu
extends Screen {
    public static GuiGraphics graphics;
    public static PoseStack poseStack;
    public static final String WEBSITE = "https://justsgmod.eu/";
    public static final String WIKI_RAM_ALLOCATION_URL = "https://justsgmod.eu/wiki/?type=1.20category=general&topic=start#Allocating%20more%20RAM";
    public static final String GITHUB = "https://github.com/Tau-ri-Dev";
    public static final String JSG_RUNNING_TEXT;
    public static final ResourceLocation LOGO_TAURI;
    public static final ResourceLocation LOGO_JSG;
    public static final int BACKGROUNDS_COUNT;
    public static final long FIRST_TRANSITION_LENGTH = 300L;
    public static final int PADDING = 10;
    public static final MainMenuNotifications NOTIFIER;
    private static final int BACKGROUND_CHANGE_ANIMATION_LENGTH = 60;
    private static final int BACKGROUND_STAY_TIME = 400;
    public static GetUpdate.UpdateResult UPDATER_RESULT;
    public static long menuDisplayed;
    public static boolean menuWasDisplayed;
    public static double firstTransitionStart;
    private static int currentButton;
    private static boolean menuWasDisplayedIgnoredFPS;
    private static int updaterNotification;
    public double tick;
    public boolean isMusicPlaying = false;
    public EnumMainMenuGateType gateType = EnumMainMenuGateType.random(null);
    private long backgroundChangeStart = 0L;
    private long lastGateChange = 0L;
    public List<JSGButtonClassic> buttonList = new ArrayList<JSGButtonClassic>();
    private double backgroundScale = 1.0;
    private int currentBackground = 0;
    private EnumMainMenuTips tipEnum = EnumMainMenuTips.random(null);
    public static boolean soundIntroPlayed;
    public int kinoXStart = -1;
    public int kinoYStart = -1;
    public int kinoXEnd = -1;
    public int kinoYEnd = -1;
    public double kinoAngle = 0.0;
    public boolean renderKino = false;
    public double kinoRenderStart = 0.0;
    public static final double KINO_ANIMATION_LENGTH = 80.0;
    public static FlybySoundInstance kinoSound;

    public GuiCustomMainMenu() {
        super((Component)Component.m_237115_((String)"narrator.screen.title"));
        this.m_86600_();
        this.createFadeIn();
    }

    public static void playMusic(boolean play) {
        JSGSoundHelperClient.playPositionedSoundClientSide(JSG.lastPlayerPosInWorld, SoundPositionedEnum.MAINMENU_MUSIC, play);
    }

    public static int[] getCenterPos(int rectWidth, int rectHeight, int winWidth, int winHeight) {
        return new int[]{(winWidth - rectWidth) / 2, (winHeight - rectHeight) / 2};
    }

    public void m_86600_() {
        this.tick = JSGMinecraftHelper.getClientTickPrecise();
    }

    public void createFadeIn() {
        this.backgroundChangeStart = (long)(this.tick - 20.0);
    }

    public ResourceLocation getIconsTexture() {
        return switch (this.gateType) {
            default -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_mw.png");
            case EnumMainMenuGateType.PEGASUS -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_pg.png");
            case EnumMainMenuGateType.UNIVERSE -> new ResourceLocation("jsg", "textures/gui/mainmenu/icons_uni.png");
        };
    }

    public void updateMusic() {
        if (this.tick - (double)menuDisplayed <= 300.0) {
            return;
        }
        if (this.tick - (double)menuDisplayed > 600.0) {
            this.isMusicPlaying = JSGSoundHelperClient.getRecord(SoundPositionedEnum.MAINMENU_MUSIC, JSG.lastPlayerPosInWorld).isPlaying();
        }
        if (!this.isMusicPlaying && ((Boolean)JSGConfig.General.playMusic.get()).booleanValue()) {
            this.isMusicPlaying = true;
            GuiCustomMainMenu.playMusic(true);
        }
        if (!((Boolean)JSGConfig.General.playMusic.get()).booleanValue() && this.isMusicPlaying) {
            GuiCustomMainMenu.playMusic(false);
        }
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return GuiCustomMainMenu.getCenterPos(rectWidth, rectHeight, this.f_96543_, this.f_96544_);
    }

    public void m_7856_() {
        if (((Boolean)JSGConfig.General.mainMenuDebugMode.get()).booleanValue()) {
            menuWasDisplayed = false;
        }
        this.createFadeIn();
        this.buttonList.clear();
        int id = -1;
        int texSize = 128;
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 32, 32, 32, 32, false, Component.m_237115_((String)"menu.singleplayer").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 64, 32, 32, 32, false, Component.m_237115_((String)"menu.multiplayer").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 32, 0, 32, 32, false, Component.m_237115_((String)"menu.options").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 0, 32, 32, 32, false, Component.m_237115_((String)"menu.quit").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 0, 0, 32, 32, false, Component.m_237115_((String)"menu.about").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 64, 0, 32, 32, false, Component.m_237115_((String)"fml.menu.mods").getString()));
        this.initUpdaterNotifier();
    }

    public int getButtonForDisplay(int offset) {
        if (offset > 0) {
            return this.getNextButton(offset);
        }
        if (offset < 0) {
            return this.getPreviousButton(offset * -1);
        }
        return currentButton;
    }

    private int getNextButton(int offset) {
        return (currentButton + offset) % this.buttonList.size();
    }

    private int getPreviousButton(int offset) {
        int id = currentButton;
        for (int i = 0; i < offset; ++i) {
            if (--id >= 0) continue;
            id = this.buttonList.size() - 1;
        }
        return id;
    }

    public void updateGateType() {
        if (this.tick - (double)this.lastGateChange < 600.0) {
            return;
        }
        this.lastGateChange = (long)this.tick;
        this.gateType = EnumMainMenuGateType.random(this.gateType);
        this.tipEnum = EnumMainMenuTips.random(this.tipEnum);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiCustomMainMenu.graphics = graphics;
        GuiHelper.currentStack = GuiCustomMainMenu.graphics.m_280168_();
        graphics.m_280168_().m_85836_();
        Lighting.m_166384_();
        RenderSystem.enableDepthTest();
        poseStack = graphics.m_280168_();
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.m_86600_();
        if (menuDisplayed == -1L) {
            menuDisplayed = (long)this.tick;
            this.createFadeIn();
        }
        this.updateMusic();
        this.updateGateType();
        this.drawBackground();
        this.drawButtons(mouseX, mouseY);
        this.drawTitles();
        this.drawFg(mouseX, mouseY);
        if (!menuWasDisplayed) {
            firstTransitionStart = this.tick;
            if (Minecraft.m_91087_().m_260875_() >= 25) {
                menuWasDisplayed = true;
            }
        }
        this.drawFirstAnimation();
        if (!menuWasDisplayedIgnoredFPS) {
            this.firstInit();
            menuWasDisplayedIgnoredFPS = true;
        }
        graphics.m_280168_().m_85849_();
    }

    public void drawFirstAnimation() {
        if (!((Boolean)JSGConfig.General.enableLogo.get()).booleanValue()) {
            return;
        }
        double current = this.tick - firstTransitionStart;
        if (current > 300.0) {
            return;
        }
        double step = 60.0;
        double alpha = 1.0 - Math.min(1.0, Math.max(0.0, current - 4.5 * step) / (step / 2.0));
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 52.0f);
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        int introFrameInt = (int)current - 60;
        if (introFrameInt >= 0) {
            GuiHelper.drawRect(0, 0, this.f_96543_, this.f_96544_, new Color(255, 255, 255, (int)(255.0 * alpha)).getRGB());
        } else {
            GuiHelper.drawRect(0, 0, this.f_96543_, this.f_96544_, new Color(0, 0, 0, 255).getRGB());
        }
        if (!soundIntroPlayed && introFrameInt >= 0) {
            JSGSoundHelperClient.playPositionedSoundClientSide(JSG.lastPlayerPosInWorld, SoundPositionedEnum.MAINMENU_INTRO, true);
            soundIntroPlayed = true;
        }
        Object introFrame = "";
        introFrame = introFrameInt < 10 ? "00" + introFrameInt : (introFrameInt < 100 ? "0" + introFrameInt : "" + introFrameInt);
        if (introFrameInt < 1) {
            introFrame = "001";
        }
        if (introFrameInt <= 175 && introFrameInt > -1) {
            Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/wormhole/milkyway/ezgif-frame-" + (String)introFrame + ".jpg"));
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, 0.0f, 0.0f, 1920, 1080, this.f_96543_, this.f_96544_, 1920.0f, 1080.0f);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int[] center = this.getCenterPos(0, 0);
        if (alpha > 0.75) {
            this.drawCenteredString(this.f_96547_, "We are not associated with Mojang.", center[0], this.f_96544_ - 10 - 10, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = NOTIFIER.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            for (JSGButtonClassic guibutton : this.buttonList) {
                if (!guibutton.m_6375_(mouseX, mouseY, mouseButton)) continue;
                guibutton.m_7435_(this.getMinecraft().m_91106_());
                this.actionPerformed(guibutton);
                result = true;
            }
            int sizeXTauri = this.f_96543_ / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            int sizeYMojang = 0;
            if (GuiHelper.isPointInRegion(10, this.f_96544_ - 10 - sizeYTauri - sizeYMojang - 8, sizeXTauri, sizeYTauri, (int)mouseX, (int)mouseY)) {
                GetUpdate.openWebsiteToClient(GITHUB);
                result = true;
            }
            int jsgSizeX = this.f_96547_.m_92895_(JSG_RUNNING_TEXT);
            int jsgSizeY = 10;
            int sizeXJSG = (int)((double)this.f_96543_ / 2.33);
            int sizeYJSG = 603 * sizeXJSG / 1586;
            int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
            int x = (int)((double)center[0] * 0.25);
            int y = (int)((double)center[1] * 0.5);
            if (GuiHelper.isPointInRegion(10, 10, jsgSizeX, jsgSizeY, (int)mouseX, (int)mouseY) || GuiHelper.isPointInRegion(x, y, sizeXJSG, sizeYJSG, (int)mouseX, (int)mouseY)) {
                GetUpdate.openWebsiteToClient(WEBSITE);
                result = true;
            }
        }
        return result;
    }

    public boolean m_6050_(double x, double y, double amount) {
        super.m_6050_(x, y, amount);
        if (amount == 0.0) {
            return false;
        }
        int topY = Integer.MAX_VALUE;
        int leftX = Integer.MAX_VALUE;
        int bottomY = 0;
        int width = 0;
        for (JSGButtonClassic btn : this.buttonList) {
            if (!btn.f_93624_) continue;
            if (btn.m_252907_() < topY) {
                topY = btn.m_252907_();
            }
            if (btn.m_252754_() < leftX) {
                leftX = btn.m_252754_();
            }
            if (btn.m_5711_() > width) {
                width = btn.m_5711_();
            }
            if (btn.m_252907_() + btn.m_93694_() <= bottomY) continue;
            bottomY = btn.m_252907_() + btn.m_93694_();
        }
        if (GuiHelper.isPointInRegion(leftX, topY, width, bottomY - topY, (int)x, (int)y)) {
            if ((currentButton += amount < 0.0 ? 1 : -1) < 0) {
                currentButton = this.buttonList.size() - 1;
            }
            if (currentButton >= this.buttonList.size()) {
                currentButton = 0;
            }
            return true;
        }
        return false;
    }

    protected void actionPerformed(@Nonnull JSGButtonClassic button) {
        if (this.f_96541_ == null) {
            return;
        }
        if (button.id < this.buttonList.size()) {
            switch (button.id) {
                case 0: {
                    this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
                    break;
                }
                case 1: {
                    this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this));
                    break;
                }
                case 2: {
                    this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_));
                    break;
                }
                case 3: {
                    this.f_96541_.m_91395_();
                    break;
                }
                case 4: {
                    GetUpdate.openWebsiteToClient(WEBSITE);
                    break;
                }
                case 5: {
                    this.f_96541_.m_91152_((Screen)new ModListScreen((Screen)this));
                }
            }
        }
    }

    public void drawButtons(int mouseX, int mouseY) {
        for (JSGButtonClassic button : this.buttonList) {
            button.f_93624_ = false;
            boolean bl = button.f_93623_ = GuiCustomMainMenu.NOTIFIER.currentDisplayed == null;
            if (!(button instanceof IconButton)) continue;
            ((IconButton)button).texture = this.getIconsTexture();
        }
        for (int i = -2; i <= 2; ++i) {
            RenderSystem.enableBlend();
            int btn = this.getButtonForDisplay(i);
            IconButton button = (IconButton)this.buttonList.get(btn);
            int x = this.f_96543_ - (button.width + 20);
            int y = this.getCenterPos(button.width, button.height)[1] + i * (button.height + 10);
            button.m_252865_(x);
            button.m_253211_(y);
            button.f_93624_ = true;
            button.drawButton(graphics, mouseX, mouseY);
            if (i == 0) {
                button.drawButton(graphics, mouseX, mouseY);
                button.drawButton(graphics, mouseX, mouseY);
                button.drawButton(graphics, mouseX, mouseY);
                String[] label = button.label;
                int labelHigh = label.length * 10;
                int syDefault = button.m_252907_() + button.height / 2;
                int syStart = syDefault - labelHigh / 2;
                int color = 0xFFFFFF;
                for (int ii = 0; ii < label.length; ++ii) {
                    graphics.m_280488_(this.f_96547_, label[ii], button.m_252754_() - 5 - this.f_96547_.m_92895_(label[ii]), syStart + ii * 10, color);
                    color = 0x404040;
                }
            }
            if (i == -1 || i == 1) {
                button.drawButton(graphics, mouseX, mouseY);
            }
            RenderSystem.disableBlend();
        }
    }

    public void drawBackground() {
        RenderSystem.enableBlend();
        this.currentBackground = (int)(Math.floor(this.tick / 400.0) % (double)BACKGROUNDS_COUNT);
        double timeHere = this.tick % 400.0;
        if (timeHere > 370.0 && this.backgroundChangeStart == -1L) {
            this.backgroundChangeStart = (long)this.tick;
        }
        float scale = 1.0f + (float)(timeHere / 400.0 * (double)0.2f);
        double coef = 0.0;
        double current = this.tick - (double)this.backgroundChangeStart;
        double currentImgCoef = this.tick % 400.0 / 400.0;
        if (this.backgroundChangeStart != -1L) {
            if (current <= 60.0) {
                coef = Math.min(Math.sin(current / 60.0 * Math.PI) * 1.1, 1.0);
            } else {
                this.backgroundChangeStart = -1L;
            }
        }
        poseStack.m_85836_();
        int[] center = this.getCenterPos(0, 0);
        poseStack.m_252880_((float)center[0], (float)center[1], 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        this.backgroundScale = scale;
        Texture.bindTextureWithMc(MainMenuBackground.get(this.currentBackground));
        GuiHelper.drawScaledCustomSizeModalRect(-(this.f_96543_ / 2), -(this.f_96544_ / 2), 0.0f, 0.0f, 1921, 1018, this.f_96543_, this.f_96544_, 1920.0f, 1017.0f);
        poseStack.m_85849_();
        GuiHelper.drawRect(0, this.f_96544_ - 2, this.f_96543_, this.f_96544_, 0x6E6E6EFF);
        GuiHelper.drawRect(0, this.f_96544_ - 2, (int)((double)this.f_96543_ * currentImgCoef), this.f_96544_, -336860161);
        if (coef > 0.0) {
            GuiHelper.drawRect(0, 0, this.f_96543_, this.f_96544_, new Color(0, 0, 0, (int)(255.0 * coef)).getRGB());
        }
        RenderSystem.disableBlend();
        this.gateType.renderGate(this.f_96543_ + 20, this.getCenterPos(0, 0)[1], 45.0f, this.tick);
    }

    public void drawTitles() {
        if (((Boolean)JSGConfig.General.mainMenuDebugMode.get()).booleanValue()) {
            int[] center = this.getCenterPos(0, 0);
            center[1] = center[1] - 30;
            int i = 0;
            graphics.m_280488_(this.f_96547_, "FPS: " + Minecraft.m_91087_().m_260875_(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "width: " + this.f_96543_, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "height: " + this.f_96544_, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "time: " + String.format("%.4f", this.tick), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "timeHere: " + String.format("%.4f", this.tick % 400.0), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "backgroundScale: " + String.format("%.4f", this.backgroundScale), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "backgroundChangeStart: " + this.backgroundChangeStart, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "currentBackground: " + this.currentBackground, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "gateType: " + this.gateType.toString(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "currentButton: " + currentButton, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "updater: (Status: " + GuiCustomMainMenu.UPDATER_RESULT.result.toString() + "; Got: " + GuiCustomMainMenu.UPDATER_RESULT.response + ")", 10, center[1] + 10 * ++i, 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96547_, JSG_RUNNING_TEXT, 10, 10, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Running on Minecraft Java 1.20.1", 10, 20, 0xFFFFFF);
        int sizeXTauri = this.f_96543_ / 10;
        int sizeYTauri = 230 * sizeXTauri / 411;
        int sizeYMojang = 0;
        int sizeXJSG = (int)((double)this.f_96543_ / 2.33);
        int sizeYJSG = 603 * sizeXJSG / 1586;
        int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
        int x = (int)((double)center[0] * 0.25);
        int y = (int)((double)center[1] * 0.5);
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(LOGO_TAURI);
        GuiHelper.drawScaledCustomSizeModalRect(10, this.f_96544_ - 10 - sizeYTauri - sizeYMojang - 8, 0.0f, 0.0f, 411, 230, sizeXTauri, sizeYTauri, 410.0f, 229.0f);
        Texture.bindTextureWithMc(LOGO_JSG);
        GuiHelper.drawScaledCustomSizeModalRect(x, y, 0.0f, 0.0f, 1586, 603, sizeXJSG, sizeYJSG, 1586.0f, 603.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 51.0f);
        String[] tip = this.tipEnum.text;
        int startY = -(tip.length * 10);
        int i = 0;
        center = this.getCenterPos(0, 0);
        for (String s : tip) {
            this.drawCenteredString(this.f_96547_, Component.m_237115_((String)s).getString(), center[0], this.f_96544_ - 10 + startY + i * 10, 13544744, true);
            ++i;
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public void drawFg(int mouseX, int mouseY) {
        NOTIFIER.update();
        if (GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            for (JSGButtonClassic b : this.buttonList) {
                if (!(b instanceof IconButton) || !b.f_93624_ || b.id == currentButton) continue;
                ((IconButton)b).drawFg(mouseX, mouseY);
            }
            int sizeXTauri = this.f_96543_ / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            int sizeYMojang = 0;
            if (GuiHelper.isPointInRegion(10, this.f_96544_ - 10 - sizeYTauri - sizeYMojang - 8, sizeXTauri, sizeYTauri, mouseX, mouseY)) {
                List<MutableComponent> authors = List.of(Component.m_237113_((String)"Click to open Tau'ri Dev github").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
                graphics.m_280677_(this.f_96547_, authors, Optional.empty(), mouseX, mouseY);
            }
        } else {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 50.0f);
            GuiHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 0, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            NOTIFIER.render(mouseX, mouseY, this.f_96543_, this.f_96544_, this);
            poseStack.m_85849_();
        }
    }

    public void drawCenteredString(Font fontRendererIn, @Nonnull String text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            graphics.m_280137_(fontRendererIn, text, x, y, color);
            return;
        }
        graphics.m_280056_(fontRendererIn, text, x - fontRendererIn.m_92895_(text) / 2, y, color, false);
    }

    public void drawKinoAnimation() {
        double anim = this.tick - this.kinoRenderStart;
        if (!this.renderKino) {
            if (kinoSound != null) {
                GuiCustomMainMenu.kinoSound.currentPosition = null;
                kinoSound.m_7788_();
            }
            kinoSound = null;
            if (anim > 400.0 && Math.random() < (double)0.003f) {
                this.renderKino = true;
                this.kinoRenderStart = this.tick;
                double angle = Math.pow(Math.random(), 2.0) * 2.0 * Math.PI;
                this.kinoXStart = (int)(Math.cos(angle) * 2.5 + 1.0) * (this.f_96543_ / 2);
                this.kinoYStart = (int)(Math.sin(angle) * 2.5 + 1.0) * (this.f_96544_ / 2);
                this.kinoAngle = angle += Math.PI * Math.random() * 1.5;
                this.kinoXEnd = (int)(Math.cos(angle) * 2.5 + 1.0) * (this.f_96543_ / 2);
                this.kinoYEnd = (int)(Math.sin(angle) * 2.5 + 1.0) * (this.f_96544_ / 2);
            }
            return;
        }
        if (anim > 80.0) {
            this.renderKino = false;
            return;
        }
        int kinoX = (int)((double)this.kinoXStart + (double)(this.kinoXEnd - this.kinoXStart) * (anim / 80.0));
        int kinoY = (int)((double)this.kinoYStart + (double)(this.kinoYEnd - this.kinoYStart) * (anim / 80.0));
        BlockPos pos = JSG.lastPlayerPosInWorld.m_121955_((Vec3i)new BlockPos(kinoX, kinoY, 0));
        if (kinoSound == null) {
            kinoSound = JSGSoundHelperClient.playPositionedFlyBySound(pos, SoundPositionedEnum.KINO_FLYBY, 1.0f, 1.3f);
            GuiCustomMainMenu.kinoSound.centerPos = JSG.lastPlayerPosInWorld;
        } else {
            GuiCustomMainMenu.kinoSound.currentPosition = pos;
            kinoSound.m_7788_();
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.kinoAngle));
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Texture.bindTextureWithMc(LOGO_TAURI);
        GuiHelper.drawScaledCustomSizeModalRect(kinoX, kinoY, 0.0f, 0.0f, 410, 229, 100, 50, 411.0f, 230.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public void initUpdaterNotifier() {
        if (GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.NEWER_AVAILABLE || GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR) {
            boolean error;
            boolean bl = error = GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR;
            if (updaterNotification == -1 || NOTIFIER.get(updaterNotification) == null) {
                updaterNotification = !error ? NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                    {
                        String update = Component.m_237115_((String)"menu.updater.download").getString();
                        int width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                        this.add(new JSGButtonClassic(40, -width - 5, 0, width, 20, update));
                        update = Component.m_237115_((String)"menu.updater.close").getString();
                        width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                        this.add(new JSGButtonClassic(41, 5, 0, width, 20, update));
                    }
                }, new String[]{"New update is available!", "", "", "You can update to version " + GuiCustomMainMenu.UPDATER_RESULT.response, "It is highly recommended to update to this version!", "Some dangerous bugs should be fixed in this version."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() - 5);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_252865_(xCenter + 5);
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_253211_(((JSGButtonClassic)((Object)this.buttons.get(0))).m_252907_());
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull JSGButtonClassic button) {
                        switch (button.id) {
                            case 40: {
                                GetUpdate.openWebsiteToClient(GetUpdate.DOWNLOAD_URL_USER);
                                break;
                            }
                            case 41: {
                                this.dismiss();
                                break;
                            }
                        }
                    }
                }) : NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                    {
                        String close = Component.m_237115_((String)"menu.updater.close").getString();
                        int width = GuiCustomMainMenu.this.f_96547_.m_92895_(close) + 20;
                        this.add(new JSGButtonClassic(41, -width / 2, 0, width, 20, close));
                    }
                }, new String[]{"Error while checking update!", GuiCustomMainMenu.UPDATER_RESULT.response, "", "Can not get response from the server!", "Please check your internet connection.", "Problem can also be on our side."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() / 2);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull JSGButtonClassic button) {
                        if (button.id == 41) {
                            this.dismiss();
                        }
                    }
                });
            }
        }
    }

    public void firstInit() {
        if (JSG.memoryTotal < 0x80000000L) {
            NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                {
                    String update = Component.m_237115_((String)"menu.ram.help").getString();
                    int width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                    this.add(new JSGButtonClassic(50, -width - 5, 0, width, 20, update));
                    update = Component.m_237115_((String)"menu.updater.close").getString();
                    width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                    this.add(new JSGButtonClassic(51, 5, 0, width, 20, update));
                }
            }, new String[]{"Allocate more RAM!", "", "Recommended minimum RAM for JSG mod is 2GB!", "By ignoring this fact, you can", "run into troubles with this mod."}){

                @Override
                public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                    super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                    int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() - 5);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_252865_(xCenter + 5);
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_253211_(((JSGButtonClassic)((Object)this.buttons.get(0))).m_252907_());
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                }

                @Override
                public void actionPerformed(@Nonnull JSGButtonClassic button) {
                    switch (button.id) {
                        case 50: {
                            GetUpdate.openWebsiteToClient(GuiCustomMainMenu.WIKI_RAM_ALLOCATION_URL);
                            break;
                        }
                        case 51: {
                            this.dismiss();
                            break;
                        }
                    }
                }
            });
            NOTIFIER.update();
        }
    }

    static {
        JSG_RUNNING_TEXT = "Just Stargate Mod v" + JSG.MOD_VERSION.replaceAll("1.20.1-", "");
        LOGO_TAURI = new ResourceLocation("jsg", "textures/gui/mainmenu/tauri_dev_logo.png");
        LOGO_JSG = new ResourceLocation("jsg", "textures/gui/mainmenu/jsg_logo.png");
        BACKGROUNDS_COUNT = (Integer)JSGConfig.General.backgroundImagesCount.get();
        NOTIFIER = MainMenuNotifications.getManager();
        UPDATER_RESULT = GetUpdate.LAST_UPDATE_RESULT;
        menuDisplayed = -1L;
        menuWasDisplayed = false;
        firstTransitionStart = 0.0;
        currentButton = 0;
        menuWasDisplayedIgnoredFPS = false;
        updaterNotification = -1;
        if (((Boolean)JSGConfig.General.mainMenuDebugMode.get()).booleanValue()) {
            NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                {
                    String close = Component.m_237115_((String)"menu.updater.close").getString();
                    int width = Minecraft.m_91087_().f_91062_.m_92895_(close) + 20;
                    this.add(new JSGButtonClassic(41, -width / 2, 0, width, 20, close));
                }
            }, new String[]{"Report from startup:", "", "Total textures loaded/not: " + JSG.ClientModEvents.LoadingStats.loadedTextures + "/" + JSG.ClientModEvents.LoadingStats.notLoadedTextures, "Total models loaded/not: " + JSG.ClientModEvents.LoadingStats.loadedModels + "/" + JSG.ClientModEvents.LoadingStats.notLoadedModels}){

                @Override
                public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                    super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                    int xCenter = GuiCustomMainMenu.getCenterPos(0, 0, width, height)[0];
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() / 2);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                }

                @Override
                public void actionPerformed(@Nonnull JSGButtonClassic button) {
                    if (button.id == 41) {
                        this.dismiss();
                    }
                }
            });
        }
        soundIntroPlayed = false;
    }

    public static class MainMenuBackground {
        protected static final String PATH = "textures/gui/mainmenu/background";
        protected static final String END = ".jpg";

        public static ResourceLocation get(int id) {
            return new ResourceLocation("jsg", PATH + id + END);
        }
    }
}

