/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.api.TextureOverlay;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.helpers.BlockHelpers;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public enum BiomeOverlayEnum implements TextureOverlay
{
    NORMAL("", ChatFormatting.GRAY),
    FROST("_frost", ChatFormatting.DARK_AQUA),
    MOSSY("_mossy", ChatFormatting.DARK_GREEN),
    AGED("_aged", ChatFormatting.GRAY),
    SOOTY("_sooty", ChatFormatting.DARK_GRAY);

    private final String suffix;
    private final ChatFormatting color;
    private final String unlocalizedName;

    private BiomeOverlayEnum(String suffix, ChatFormatting color) {
        this.suffix = suffix;
        this.color = color;
        this.unlocalizedName = "gui.stargate.biome_overlay." + this.name().toLowerCase();
    }

    public String getLocalizedColorizedName() {
        return String.valueOf(this.color) + I18n.m_118938_((String)this.unlocalizedName, (Object[])new Object[0]);
    }

    public static BiomeOverlayEnum updateBiomeOverlay(Level world, BlockPos topmostBlock, EnumSet<BiomeOverlayEnum> supportedOverlays) {
        BiomeOverlayEnum ret = BiomeOverlayEnum.getBiomeOverlay(world, topmostBlock);
        if (supportedOverlays.contains(ret)) {
            return ret;
        }
        return NORMAL;
    }

    private static BiomeOverlayEnum getBiomeOverlay(Level world, BlockPos topmostBlock) {
        Biome biome = (Biome)world.m_204166_(topmostBlock).m_203334_();
        if (world.m_46472_() != Level.f_46429_ && !BlockHelpers.isBlockDirectlyUnderSky(world, topmostBlock)) {
            return NORMAL;
        }
        if (biome.m_198904_(topmostBlock)) {
            return FROST;
        }
        BiomeOverlayEnum overlay = JSGConfigUtil.getBiomeOverrideBiomes().get(biome);
        if (overlay != null) {
            return overlay;
        }
        return NORMAL;
    }

    public static BiomeOverlayEnum fromString(String name) {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            if (!biomeOverlay.toString().equals(name)) continue;
            return biomeOverlay;
        }
        return null;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

