/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.stargate.network.SymbolInterface;

public enum EnumSpinDirection {
    COUNTER_CLOCKWISE(0, -1),
    CLOCKWISE(1, 1);

    public int id;
    public int mul;

    private EnumSpinDirection(int id, int mul) {
        this.id = id;
        this.mul = mul;
    }

    public EnumSpinDirection opposite() {
        if (this == CLOCKWISE) {
            return COUNTER_CLOCKWISE;
        }
        return CLOCKWISE;
    }

    public float getDistance(SymbolInterface currentRingSymbol, SymbolInterface targetRingSymbol) {
        int indexDiff = this == CLOCKWISE ? currentRingSymbol.getAngleIndex() - targetRingSymbol.getAngleIndex() : targetRingSymbol.getAngleIndex() - currentRingSymbol.getAngleIndex();
        float angle = (float)indexDiff * currentRingSymbol.getSymbolType().getAnglePerGlyph();
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static EnumSpinDirection valueOf(int id) {
        return id == 0 ? COUNTER_CLOCKWISE : CLOCKWISE;
    }
}

