/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import java.util.HashMap;
import java.util.Map;

public enum EnumStargateState {
    IDLE(0),
    DIALING(1),
    DIALING_COMPUTER(2),
    ENGAGED(3),
    ENGAGED_INITIATING(4),
    UNSTABLE_OPENING(5),
    UNSTABLE_CLOSING(6),
    FAILING(7),
    INCOMING(8);

    public final int id;
    private static final Map<Integer, EnumStargateState> idMap;

    private EnumStargateState(int id) {
        this.id = id;
    }

    public boolean idle() {
        return this == IDLE;
    }

    public boolean incoming() {
        return this == INCOMING;
    }

    public boolean engaged() {
        return this == ENGAGED || this == ENGAGED_INITIATING;
    }

    public boolean initiating() {
        return this == ENGAGED_INITIATING;
    }

    public boolean notInitiating() {
        return this == ENGAGED;
    }

    public boolean dialingComputer() {
        return this == DIALING_COMPUTER;
    }

    public boolean failing() {
        return this == FAILING;
    }

    public boolean dialing() {
        return this == DIALING || this == DIALING_COMPUTER;
    }

    public boolean dialingDHD() {
        return this == DIALING;
    }

    public boolean unstable() {
        return this == UNSTABLE_OPENING || this == UNSTABLE_CLOSING;
    }

    public static EnumStargateState valueOf(int id) {
        return idMap.get(id);
    }

    static {
        idMap = new HashMap<Integer, EnumStargateState>();
        for (EnumStargateState state : EnumStargateState.values()) {
            idMap.put(state.id, state);
        }
    }
}

