/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.ISpinHelper;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.util.math.MathFunction;
import dev.tauri.jsg.util.math.MathFunctionLinear;
import dev.tauri.jsg.util.math.MathFunctionQuadratic;
import dev.tauri.jsg.util.math.MathRange;
import dev.tauri.jsg.util.math.MathRangedFunction;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StargateClassicSpinHelper
implements ISpinHelper {
    public static float A_ANGLE_PER_TICK = 1.8f;
    public static final float U_SPEEDUP_TIME = 35.0f;
    public static final float S_STOP_TIME = 25.0f;
    public SymbolTypeEnum<?> symbolType;
    public boolean isSpinning;
    public SymbolInterface currentSymbol;
    public EnumSpinDirection direction = EnumSpinDirection.CLOCKWISE;
    private long spinStartTime;
    private SymbolInterface targetSymbol;
    private float targetRotationOffset;
    public int plusRounds;
    public float speedFactor;
    private final Map<MathRange, MathFunction> phases = new HashMap<MathRange, MathFunction>(3);

    public StargateClassicSpinHelper() {
    }

    @Override
    public boolean getIsSpinning() {
        return this.isSpinning;
    }

    @Override
    public void setIsSpinning(boolean value) {
        this.isSpinning = value;
    }

    @Override
    public SymbolInterface getCurrentSymbol() {
        return this.currentSymbol;
    }

    @Override
    public void setCurrentSymbol(SymbolInterface symbol) {
        this.currentSymbol = symbol;
    }

    @Override
    public SymbolInterface getTargetSymbol() {
        return this.targetSymbol;
    }

    private static MathRangedFunction getSpeedupRangedFunction(float a, float u) {
        return new MathRangedFunction(new MathRange(0.0f, u), new MathFunctionQuadratic(a / (2.0f * u), 0.0f, 0.0f));
    }

    private static MathFunctionLinear getLinearSpinFunction(float a) {
        return new MathFunctionLinear(a, -a * 35.0f / 2.0f);
    }

    private static MathFunctionQuadratic getStopFunction(float a, float u, float s, float x0) {
        return new MathFunctionQuadratic(-a / (2.0f * s), a + a * x0 / s, -(a * u / 2.0f + a * x0 * x0 / (2.0f * s)));
    }

    private static float getX0(float speedFactor, float targetAngle) {
        return targetAngle / (A_ANGLE_PER_TICK * speedFactor) + 5.0f;
    }

    private static float getTargetRotation(float speedFactor, float x0) {
        return A_ANGLE_PER_TICK * speedFactor * x0 + A_ANGLE_PER_TICK * speedFactor * -10.0f / 2.0f;
    }

    public static int getAnimationDuration(float speedFactor, float distance) {
        return (int)(StargateClassicSpinHelper.getX0(speedFactor, distance) + 25.0f);
    }

    public static float getAnimationDistance(float speedFactor, int duration) {
        float distance = (float)duration * A_ANGLE_PER_TICK * speedFactor - 35.0f * A_ANGLE_PER_TICK * speedFactor - 25.0f * A_ANGLE_PER_TICK * speedFactor;
        if (distance < 15.0f) {
            distance = 15.0f;
        }
        return distance;
    }

    public StargateClassicSpinHelper(SymbolTypeEnum<?> symbolType, SymbolInterface currentSymbol, EnumSpinDirection spinDirection, boolean isSpinning, SymbolInterface targetRingSymbol, long spinStartTime, int plusRounds) {
        this.symbolType = symbolType;
        this.currentSymbol = currentSymbol;
        this.direction = spinDirection;
        this.isSpinning = isSpinning;
        this.targetSymbol = targetRingSymbol;
        this.spinStartTime = spinStartTime;
        this.plusRounds = plusRounds;
    }

    @Override
    public void initRotation(float speedFactorNew, long totalWorldTime, SymbolInterface targetSymbol, EnumSpinDirection direction, float startOffset, int plusRounds) {
        this.speedFactor = speedFactorNew;
        float distance = direction.getDistance(this.currentSymbol, targetSymbol);
        float x0 = StargateClassicSpinHelper.getX0(this.speedFactor, distance += (float)(360 * plusRounds));
        this.targetRotationOffset = StargateClassicSpinHelper.getTargetRotation(this.speedFactor, x0);
        this.phases.clear();
        MathRangedFunction SPEEDUP_PHASE = StargateClassicSpinHelper.getSpeedupRangedFunction(A_ANGLE_PER_TICK * this.speedFactor, 35.0f);
        MathFunctionLinear LINEAR_SPIN_FUNCTION = StargateClassicSpinHelper.getLinearSpinFunction(A_ANGLE_PER_TICK * this.speedFactor);
        if (x0 < 35.0f) {
            x0 = (x0 + 25.0f) / 2.0f;
            float a = distance / x0;
            MathRangedFunction speedup = StargateClassicSpinHelper.getSpeedupRangedFunction(a, x0);
            this.phases.put(speedup.range, speedup.function);
            this.phases.put(new MathRange(x0, x0 + x0), StargateClassicSpinHelper.getStopFunction(a, x0, x0, x0));
        } else {
            this.phases.put(SPEEDUP_PHASE.range, SPEEDUP_PHASE.function);
            this.phases.put(new MathRange(35.0f, x0), LINEAR_SPIN_FUNCTION);
            this.phases.put(new MathRange(x0, x0 + 25.0f), StargateClassicSpinHelper.getStopFunction(A_ANGLE_PER_TICK * this.speedFactor, 35.0f, 25.0f, x0));
        }
        this.targetSymbol = targetSymbol;
        this.direction = direction;
        this.spinStartTime = totalWorldTime;
        this.isSpinning = true;
    }

    private float calculate(float tick) {
        if (tick < 0.0f) {
            return 0.0f;
        }
        for (Map.Entry<MathRange, MathFunction> phase : this.phases.entrySet()) {
            if (!phase.getKey().test(Float.valueOf(tick))) continue;
            return phase.getValue().apply(tick);
        }
        this.isSpinning = false;
        this.currentSymbol = this.targetSymbol;
        return this.targetRotationOffset;
    }

    @Override
    public float apply(double tick) {
        return this.calculate((float)(tick - (double)this.spinStartTime)) * (float)this.direction.mul;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(SymbolTypeEnum.getId(this.symbolType));
        buf.writeBoolean(this.isSpinning);
        buf.writeInt(this.currentSymbol == null ? ((SymbolInterface)Objects.requireNonNull(this.symbolType.getTopSymbol())).getId() : this.currentSymbol.getId());
        buf.writeInt(this.direction.id);
        buf.writeLong(this.spinStartTime);
        buf.writeInt(this.targetSymbol.getId());
        buf.writeInt(this.plusRounds);
        buf.writeFloat(this.speedFactor);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.symbolType = SymbolTypeEnum.byId(buf.readInt());
        this.isSpinning = buf.readBoolean();
        this.currentSymbol = this.symbolType.valueOf(buf.readInt());
        this.direction = EnumSpinDirection.valueOf(buf.readInt());
        this.spinStartTime = buf.readLong();
        this.targetSymbol = this.symbolType.valueOf(buf.readInt());
        this.plusRounds = buf.readInt();
        this.speedFactor = buf.readFloat();
        if (this.speedFactor < 0.01f) {
            this.speedFactor = 0.01f;
        }
        if (this.isSpinning) {
            this.initRotation(this.speedFactor, this.spinStartTime, this.targetSymbol, this.direction, 0.0f, this.plusRounds);
        }
    }
}

