/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.codesender;

import dev.tauri.jsg.stargate.codesender.CodeSender;
import dev.tauri.jsg.stargate.codesender.CodeSenderType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerCodeSender
extends CodeSender {
    public UUID senderUUID;
    private Level world;

    @Override
    public void prepareToLoad(Object[] args) {
        this.world = (Level)args[0];
    }

    public PlayerCodeSender(@NonNull Player player) {
        this.senderUUID = player.m_20148_();
        this.world = player.m_9236_();
    }

    public PlayerCodeSender() {
    }

    @Override
    public void sendMessage(Component message) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_240418_(message, true);
            return;
        }
        if (player != null) {
            player.m_213846_(message);
        }
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public boolean canReceiveMessage() {
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        ItemStack gdo = player.m_21205_();
        return gdo.m_41783_() != null && gdo.m_41783_().m_128441_("linkedGate");
    }

    @Override
    public CodeSenderType getType() {
        return CodeSenderType.PLAYER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("sender_uuid", this.senderUUID);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.senderUUID = nbt.m_128342_("sender_uuid");
    }

    private Player getPlayer() {
        if (this.senderUUID == null) {
            return null;
        }
        return this.world.m_46003_(this.senderUUID);
    }
}

