/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.helpers.DimensionsHelper;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class StargateNetwork
extends SavedData {
    public static StargateNetwork INSTANCE = new StargateNetwork();
    public static final String DATA_NAME = "jsg_stargates";
    private final Map<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> GATES_MAP_BY_POS = new LinkedHashMap();
    private final Map<StargateAddress, StargatePos> GATES_MAP_BY_ADDRESS = new LinkedHashMap<StargateAddress, StargatePos>();
    public final List<ResourceLocation> generatedSpecialStructures = new ArrayList<ResourceLocation>();

    public void register(@Nonnull DimensionDataStorage storage) {
        INSTANCE = this;
        storage.m_164861_(INSTANCE::load, () -> INSTANCE, DATA_NAME);
    }

    public Map<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> getAll() {
        return this.GATES_MAP_BY_POS;
    }

    @Nullable
    public StargatePos getStargate(StargateAddress address) {
        if (address == null) {
            return null;
        }
        if (address.getSize() < 7) {
            return null;
        }
        StargatePos pos = this.GATES_MAP_BY_ADDRESS.get(address);
        if (pos != null && pos.getWorld() == null) {
            return null;
        }
        return pos;
    }

    @Nullable
    public Map<SymbolTypeEnum<?>, StargateAddress> getAddresses(StargatePos pos) {
        if (pos == null) {
            return null;
        }
        return new HashMap(this.GATES_MAP_BY_POS.get(pos));
    }

    @Nullable
    public Pair<StargatePos, StargateAddress> getRandomAddress(RandomSource random, SymbolTypeEnum<?> symbolTypeEnum, @Nullable StargateTypeEnum stargateType, @Nullable Predicate<StargatePos> customTest) {
        int size = this.GATES_MAP_BY_POS.size();
        if (size == 0) {
            return null;
        }
        ArrayList<StargatePos> blacklist = new ArrayList<StargatePos>();
        int j = 0;
        while (j < 100) {
            ++j;
            int rand = random.m_188503_(size);
            int i = 0;
            for (Map.Entry<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> entry : this.GATES_MAP_BY_POS.entrySet()) {
                StargateAddress address;
                Map<SymbolTypeEnum<?>, StargateAddress> addresses;
                if (stargateType != null && stargateType != entry.getKey().getStargateType() || ++i < rand || !(addresses = entry.getValue()).containsKey(symbolTypeEnum) || (address = addresses.get(symbolTypeEnum)) == null) continue;
                if (customTest == null) {
                    return Pair.of((Object)entry.getKey(), (Object)address);
                }
                if (blacklist.contains(entry.getKey())) continue;
                if (!customTest.test(entry.getKey())) {
                    blacklist.add(entry.getKey());
                    continue;
                }
                return Pair.of((Object)entry.getKey(), (Object)address);
            }
        }
        return null;
    }

    public void putStargate(StargateAddress address, StargatePos stargatePos) {
        HashMap map = new HashMap();
        map.put(address.getSymbolType(), address);
        this.putStargate(map, stargatePos);
    }

    public void putStargate(Map<SymbolTypeEnum<?>, StargateAddress> addressMap, StargatePos stargatePos) {
        if (addressMap == null) {
            JSG.logger.warn("Tried to add NULL-address gate! Aborting...", (Throwable)new NullPointerException());
            return;
        }
        Map<SymbolTypeEnum<?>, StargateAddress> map = this.GATES_MAP_BY_POS.get(stargatePos);
        if (map == null) {
            this.GATES_MAP_BY_POS.put(stargatePos, new HashMap(addressMap));
        } else {
            map.putAll(addressMap);
            this.GATES_MAP_BY_POS.put(stargatePos, map);
        }
        for (StargateAddress address : addressMap.values()) {
            this.GATES_MAP_BY_ADDRESS.put(address, stargatePos);
        }
        this.checkForInvalidDims();
        this.m_77762_();
    }

    public void removeStargate(StargatePos stargatePos) {
        if (stargatePos == null) {
            return;
        }
        JSG.logger.info("Removing stargate's addresses at " + String.valueOf(stargatePos) + " from the network!");
        this.GATES_MAP_BY_POS.remove(stargatePos);
        ArrayList<StargateAddress> del = new ArrayList<StargateAddress>();
        for (Map.Entry<StargateAddress, StargatePos> e : this.GATES_MAP_BY_ADDRESS.entrySet()) {
            if (e.getValue() != stargatePos) continue;
            del.add(e.getKey());
        }
        for (StargateAddress a : del) {
            this.GATES_MAP_BY_ADDRESS.remove(a);
        }
        this.m_77762_();
    }

    private void checkForInvalidDims() {
        if (JSG.currentServer == null) {
            return;
        }
        HashMap map = new HashMap(this.GATES_MAP_BY_POS);
        for (Map.Entry<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> e : map.entrySet()) {
            StargatePos pos = e.getKey();
            if (DimensionsHelper.getLevel(pos.dimension) != null) continue;
            JSG.logger.info("Removing stargate at " + String.valueOf(pos) + " from the network as dim is INVALID!");
            this.removeStargate(pos);
        }
    }

    public void renameStargate(StargatePos pos, String newName) {
        Map<SymbolTypeEnum<?>, StargateAddress> map = this.getAddresses(pos);
        this.removeStargate(pos);
        JSG.logger.info("Setting gate's name at " + String.valueOf(pos) + " to: " + newName);
        pos.setName(newName);
        this.putStargate(map, pos);
        this.m_77762_();
    }

    public StargateNetwork load(CompoundTag compound) {
        INSTANCE.fromNBT(compound);
        return INSTANCE;
    }

    public void fromNBT(CompoundTag compound) {
        this.GATES_MAP_BY_POS.clear();
        this.GATES_MAP_BY_ADDRESS.clear();
        ListTag stargateTagList = compound.m_128437_("stargates", 10);
        if (compound.m_128441_("version") && compound.m_128461_("version").equalsIgnoreCase("2.0")) {
            for (Iterator stargateTag : stargateTagList) {
                CompoundTag stargateCompound = (CompoundTag)stargateTag;
                StargatePos stargatePos = new StargatePos(stargateCompound.m_128469_("pos"));
                ListTag tagMap = stargateCompound.m_128437_("addressMap", 10);
                for (Tag addressTag : tagMap) {
                    this.putStargate(new StargateAddress((CompoundTag)addressTag), stargatePos);
                }
            }
        } else {
            StargatePos stargatePos = null;
            for (Tag baseTag : stargateTagList) {
                CompoundTag stargateCompound = (CompoundTag)baseTag;
                StargateAddress stargateAddress = new StargateAddress(stargateCompound.m_128469_("address"));
                if (stargatePos == null) {
                    stargatePos = new StargatePos(stargateCompound.m_128469_("pos"));
                }
                this.putStargate(stargateAddress, stargatePos);
            }
        }
        this.generatedSpecialStructures.clear();
        int structuresSize = compound.m_128451_("specialStructureGenerated_size");
        for (int i = 0; i < structuresSize; ++i) {
            this.generatedSpecialStructures.add(new ResourceLocation(compound.m_128461_("specialStructureGenerated_" + i)));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        JSG.logger.info("Saving SGN: Started");
        compound.m_128359_("version", "2.0");
        ListTag stargateTagList = new ListTag();
        for (Map.Entry<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> stargate : this.GATES_MAP_BY_POS.entrySet()) {
            CompoundTag sgTag = new CompoundTag();
            sgTag.m_128365_("pos", (Tag)stargate.getKey().serializeNBT());
            ListTag mapList = new ListTag();
            for (Map.Entry<SymbolTypeEnum<?>, StargateAddress> address : stargate.getValue().entrySet()) {
                mapList.add((Object)address.getValue().serializeNBT());
            }
            sgTag.m_128365_("addressMap", (Tag)mapList);
            stargateTagList.add((Object)sgTag);
        }
        compound.m_128365_("stargates", (Tag)stargateTagList);
        int structuresSize = this.generatedSpecialStructures.size();
        compound.m_128405_("specialStructureGenerated_size", structuresSize);
        for (int i = 0; i < structuresSize; ++i) {
            compound.m_128359_("specialStructureGenerated_" + i, this.generatedSpecialStructures.get(i).toString());
        }
        JSG.logger.info("Saving SGN: Done");
        return compound;
    }

    public void toBytes(ByteBuf buff) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buff);
        buf.writeInt(this.GATES_MAP_BY_POS.size());
        for (Map.Entry<StargatePos, Map<SymbolTypeEnum<?>, StargateAddress>> stargate : this.GATES_MAP_BY_POS.entrySet()) {
            stargate.getKey().toBytes(buf);
            buf.writeInt(stargate.getValue().values().size());
            for (StargateAddress address : stargate.getValue().values()) {
                address.toBytes((ByteBuf)buf);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            StargatePos pos = new StargatePos(buf);
            int addSize = buf.readInt();
            for (int j = 0; j < addSize; ++j) {
                this.putStargate(new StargateAddress(buf), pos);
            }
        }
    }
}

