/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.util.I18n;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum SymbolPegasusEnum implements SymbolInterface
{
    ROEHI(37, "Roehi", "37.obj", 11),
    ONCEEL(36, "Once El", "36.obj", 35),
    BASELAI(35, "Baselai", "35.obj", 33),
    SANDOVI(34, "Sandovi", "34.obj", 10),
    ILLUME(33, "Illume", "33.obj", 25),
    AMIWILL(32, "Amiwill", "32.obj", 30),
    SIBBRON(31, "Sibbron", "31.obj", 0),
    GILLTIN(30, "Gilltin", "30.obj", 9),
    UNKNOW2(29, "Unknow2", "29.obj", 11),
    RAMNON(28, "Ramnon", "28.obj", 24),
    OLAVII(27, "Olavii", "27.obj", 14),
    HACEMILL(26, "Hacemill", "26.obj", 16),
    POCORE(25, "Poco Re", "25.obj", 13),
    ABRIN(24, "Abrin", "24.obj", 12),
    SALMA(23, "Salma", "23.obj", 17),
    HAMLINTO(22, "Hamlinto", "22.obj", 15),
    ELENAMI(21, "Elenami", "21.obj", 7),
    TAHNAN(20, "Tahnan", "20.obj", 32),
    ZEO(19, "Zeo", "19.obj", 4),
    UNKNOW1(18, "Unknow1", "18.obj", 35),
    ROBANDUS(17, "Robandus", "17.obj", 1),
    RECKTIC(16, "Recktic", "16.obj", 6),
    ZAMILLOZ(15, "Zamilloz", "15.obj", 19),
    SUBIDO(14, "Subido", "14.obj", 3),
    DAWNRE(13, "Dawnre", "13.obj", 8),
    ACJESIS(12, "Acjesis", "12.obj", 29),
    LENCHAN(11, "Lenchan", "11.obj", 22),
    ALURA(10, "Alura", "10.obj", 21),
    CAPO(9, "Ca Po", "9.obj", 28),
    LAYLOX(8, "Laylox", "8.obj", 34),
    ECRUMIG(7, "Ecrumig", "7.obj", 20),
    AVONIV(6, "Avoniv", "6.obj", 23),
    BYDO(5, "Bydo", "5.obj", 2),
    AAXEL(4, "Aaxel", "4.obj", 26),
    ALDENI(3, "Aldeni", "3.obj", 5),
    SETAS(2, "Setas", "2.obj", 31),
    ARAMI(1, "Arami", "1.obj", 27),
    DANAMI(0, "Danami", "0.obj", 18),
    BBB(38, "Bright Blue Button", "brb.obj", -39);

    public final int id;
    public final int textureSlot;
    public final String englishName;
    public final String translationKey;
    public final ResourceLocation iconResource;
    public final ResourceLocation modelResource;

    private SymbolPegasusEnum(int id, String englishName, String model, int textureSlot) {
        this.id = id;
        this.textureSlot = textureSlot;
        this.englishName = englishName;
        this.translationKey = "glyph.jsg.pegasus." + englishName.toLowerCase().replace(" ", "_");
        this.iconResource = new ResourceLocation("jsg", "textures/gui/symbol/pegasus/" + englishName.toLowerCase().replace(" ", "_") + ".png");
        this.modelResource = ModelLoader.INSTANCE.getModelResource("pegasus/" + model);
    }

    @Override
    public boolean origin() {
        return this == SUBIDO;
    }

    @Override
    public boolean brb() {
        return this == BBB;
    }

    @Override
    public float getAngle() {
        return this.id;
    }

    @Override
    public int getAngleIndex() {
        return this.id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.getEnglishName();
    }

    @Override
    public ResourceLocation getIconResource(BiomeOverlayEnum overlay, ResourceKey<Level> dimensionId, int configOrigin) {
        return this.iconResource;
    }

    @Override
    public String localize() {
        return I18n.format(this.translationKey);
    }

    public SymbolTypeEnum<SymbolPegasusEnum> getSymbolType() {
        return SymbolTypeRegistry.PEGASUS;
    }

    @Override
    public boolean isValidForAddress() {
        return !this.brb() && !this.origin() && this != UNKNOW1 && this != UNKNOW2;
    }

    @Override
    public SymbolInterface getNext(boolean previous) {
        SymbolPegasusEnum symbol;
        int id = this.getId();
        do {
            if ((id += previous ? -1 : 1) >= 0) continue;
            id = 37;
        } while ((symbol = SymbolTypeRegistry.PEGASUS.valueOf(id %= 38)) == null || !symbol.isValidForAddress());
        return symbol;
    }

    public static class Provider
    extends SymbolTypeEnum<SymbolPegasusEnum> {
        private static final Map<Integer, SymbolPegasusEnum> ID_MAP = new HashMap<Integer, SymbolPegasusEnum>();
        private static final Map<String, SymbolPegasusEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolPegasusEnum>();

        @Override
        public SymbolPegasusEnum getFirstValidForAddress() {
            return ROEHI;
        }

        @Override
        public SymbolPegasusEnum getBRB() {
            return BBB;
        }

        @Override
        public int[] getAncientTitlePos() {
            return new int[]{330, 18};
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Tab.TabBuilder finalizeAddressTab(Tab.TabBuilder builder) {
            return builder.setTexture(new ResourceLocation("jsg", "textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 22);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TabAddress.SymbolCoords getSymbolCoords(int symbol) {
            return new TabAddress.SymbolCoords(29 + 34 * (symbol % 3), 20 + 28 * (symbol / 3));
        }

        public SymbolPegasusEnum[] getValues() {
            return SymbolPegasusEnum.values();
        }

        @Override
        public Block getBaseBlock() {
            return (Block)BlockRegistry.STARGATE_PEGASUS_BASE_BLOCK.get();
        }

        @Override
        public Item getGlyphUpgrade() {
            return (Item)ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get();
        }

        @Override
        public Block getDHDBlock() {
            return (Block)BlockRegistry.DHD_PEGASUS.get();
        }

        @Override
        public String getId() {
            return "pegasus";
        }

        @Override
        public int getIconWidth() {
            return 27;
        }

        @Override
        public int getIconHeight() {
            return 27;
        }

        @Override
        public SymbolPegasusEnum getRandomSymbol(Random random) {
            int id;
            while (this.valueOf(id = random.nextInt(38)) == null || !this.valueOf(id).isValidForAddress() || id == SymbolPegasusEnum.SUBIDO.id) {
            }
            return this.valueOf(id);
        }

        @Override
        public boolean validateDialedAddress(StargateAddressDynamic stargateAddress) {
            if (stargateAddress.size() < 7) {
                return false;
            }
            return stargateAddress.get(stargateAddress.size() - 1).origin();
        }

        @Override
        public int getMinimalSymbolCountTo(SymbolTypeEnum<?> symbolType, boolean localDial) {
            boolean eightChevrons = (Boolean)JSGConfig.Stargate.pegAndMilkUseEightChevrons.get();
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
                return localDial && !eightChevrons ? 7 : 8;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
                return localDial ? 7 : 8;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
                return 9;
            }
            return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.PEGASUS, localDial);
        }

        @Override
        public SymbolPegasusEnum getOrigin() {
            return SUBIDO;
        }

        @Override
        public int getMaxSymbolsDisplay(boolean hasUpgrade) {
            return hasUpgrade ? 8 : 6;
        }

        @Override
        public float getAnglePerGlyph() {
            return 1.0f;
        }

        @Override
        public SymbolPegasusEnum getSymbolByAngle(float angle) {
            return this.getOrigin();
        }

        @Override
        public SymbolPegasusEnum getTopSymbol() {
            return SUBIDO;
        }

        @Override
        public SymbolPegasusEnum valueOf(int id) {
            return ID_MAP.get(id);
        }

        @Override
        public SymbolPegasusEnum fromEnglishName(String englishName) {
            return ENGLISH_NAME_MAP.get(englishName.toLowerCase());
        }

        static {
            for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
                ID_MAP.put(symbol.id, symbol);
                ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
            }
            ENGLISH_NAME_MAP.put("point of origin", SUBIDO);
        }
    }
}

