/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolMilkyWayEnum;
import dev.tauri.jsg.stargate.network.SymbolPegasusEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolUniverseEnum;
import dev.tauri.jsg.stargate.network.SymbolUsage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

public class SymbolTypeRegistry {
    public static int currentId = 0;
    public static final Map<Integer, SymbolTypeEnum<?>> REGISTRY = new HashMap();
    public static final Map<SymbolUsage, Map<Integer, SymbolTypeEnum<?>>> REGISTRY_USAGE = new HashMap();
    public static final Map<String, SymbolTypeEnum<?>> REGISTRY_STRING = new HashMap();
    public static final Map<SymbolTypeEnum<?>, Integer> REGISTRY_REVERSED = new HashMap();
    public static final SymbolTypeEnum<SymbolMilkyWayEnum> MILKYWAY = SymbolTypeRegistry.registerSymbolType(SymbolUsage.STARGATES, new SymbolMilkyWayEnum.Provider());
    public static final SymbolTypeEnum<SymbolPegasusEnum> PEGASUS = SymbolTypeRegistry.registerSymbolType(SymbolUsage.STARGATES, new SymbolPegasusEnum.Provider());
    public static final SymbolTypeEnum<SymbolUniverseEnum> UNIVERSE = SymbolTypeRegistry.registerSymbolType(SymbolUsage.STARGATES, new SymbolUniverseEnum.Provider());

    @ParametersAreNonnullByDefault
    public static <E extends SymbolInterface> SymbolTypeEnum<E> registerSymbolType(SymbolUsage usage, SymbolTypeEnum<E> provider) {
        REGISTRY.put(currentId, provider);
        REGISTRY_STRING.put(provider.getId().toLowerCase(), provider);
        REGISTRY_REVERSED.put(provider, currentId);
        REGISTRY_USAGE.computeIfAbsent(usage, key -> new LinkedHashMap());
        REGISTRY_USAGE.get(usage).put(currentId, provider);
        ++currentId;
        return provider;
    }

    public static SymbolTypeEnum<?> getNext(SymbolTypeEnum<?> current, boolean previous) {
        int id = SymbolTypeEnum.getId(current) + (previous ? -1 : 1);
        if (id < 0) {
            return SymbolTypeEnum.byId(REGISTRY.size() - 1);
        }
        if (id >= REGISTRY.size()) {
            return SymbolTypeEnum.byId(0);
        }
        return SymbolTypeEnum.byId(id);
    }
}

