/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.util.I18n;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum SymbolUniverseEnum implements SymbolInterface
{
    TOP_CHEVRON(0, null),
    G1(1, "01.obj"),
    G2(2, "02.obj"),
    G3(3, "03.obj"),
    G4(4, "04.obj"),
    G5(5, "05.obj"),
    G6(6, "06.obj"),
    G7(7, "07.obj"),
    G8(8, "08.obj"),
    G9(9, "09.obj"),
    G10(10, "10.obj"),
    G11(11, "11.obj"),
    G12(12, "12.obj"),
    G13(13, "13.obj"),
    G14(14, "14.obj"),
    G15(15, "15.obj"),
    G16(16, "16.obj"),
    G17(17, "17.obj"),
    G18(18, "18.obj"),
    G19(19, "19.obj"),
    G20(20, "20.obj"),
    G21(21, "21.obj"),
    G22(22, "22.obj"),
    G23(23, "23.obj"),
    G24(24, "24.obj"),
    G25(25, "25.obj"),
    G26(26, "26.obj"),
    G27(27, "27.obj"),
    G28(28, "28.obj"),
    G29(29, "29.obj"),
    G30(30, "30.obj"),
    G31(31, "31.obj"),
    G32(32, "32.obj"),
    G33(33, "33.obj"),
    G34(34, "34.obj"),
    G35(35, "35.obj"),
    G36(36, "36.obj");

    public static final int ANGLE_PER_SECTION = 8;
    public final int id;
    public ResourceLocation modelResource;
    public final int angle;
    public final int angleIndex;
    public final String englishName;
    public final String translationKey;
    public final ResourceLocation iconResource;

    private SymbolUniverseEnum(int id, String model) {
        this.id = id;
        if (model != null) {
            this.modelResource = ModelLoader.INSTANCE.getModelResource("universe/" + model);
        }
        int id0 = id - 1;
        this.angleIndex = id0 + id0 / 4 + 1;
        this.angle = 360 - this.angleIndex * 8;
        this.englishName = "Glyph " + id;
        this.translationKey = "glyph.jsg.universe.g" + id;
        this.iconResource = new ResourceLocation("jsg", "textures/gui/symbol/universe/g" + id + ".png");
    }

    @Override
    public boolean origin() {
        return this == G17;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public int getAngleIndex() {
        return this.angleIndex;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.getEnglishName();
    }

    @Override
    public ResourceLocation getIconResource(BiomeOverlayEnum overlay, ResourceKey<Level> dimensionId, int configOrigin) {
        return this.iconResource;
    }

    @Override
    public String localize() {
        return I18n.format(this.translationKey);
    }

    public SymbolTypeEnum<SymbolUniverseEnum> getSymbolType() {
        return SymbolTypeRegistry.UNIVERSE;
    }

    @Override
    public boolean isValidForAddress() {
        return this != TOP_CHEVRON && !this.origin();
    }

    @Override
    public SymbolInterface getNext(boolean previous) {
        SymbolUniverseEnum symbol;
        int id = this.getId();
        do {
            if ((id += previous ? -1 : 1) >= 0) continue;
            id = 36;
        } while ((symbol = SymbolTypeRegistry.UNIVERSE.valueOf(id %= 37)) == null || !symbol.isValidForAddress());
        return symbol;
    }

    public static class Provider
    extends SymbolTypeEnum<SymbolUniverseEnum> {
        private static final Map<Integer, SymbolUniverseEnum> ID_MAP = new HashMap<Integer, SymbolUniverseEnum>();
        private static final Map<String, SymbolUniverseEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolUniverseEnum>();

        @Override
        public SymbolUniverseEnum getFirstValidForAddress() {
            return G1;
        }

        @Override
        public SymbolUniverseEnum getBRB() {
            return null;
        }

        @Override
        public int[] getAncientTitlePos() {
            return new int[]{330, 36};
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Tab.TabBuilder finalizeAddressTab(Tab.TabBuilder builder) {
            return builder.setTexture(new ResourceLocation("jsg", "textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 44);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TabAddress.SymbolCoords getSymbolCoords(int symbol) {
            return new TabAddress.SymbolCoords(24 + 16 * (symbol % 6), 20 + 45 * (symbol / 6));
        }

        @Override
        public float getAnglePerGlyph() {
            return 8.0f;
        }

        @Override
        public SymbolUniverseEnum getSymbolByAngle(float angle) {
            for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
                if ((float)symbol.angle != angle) continue;
                return symbol;
            }
            for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
                if ((float)symbol.angle != 360.0f - angle) continue;
                return symbol;
            }
            return this.getOrigin();
        }

        @Override
        public float getAngleOfNearest(float angle) {
            int end = 38;
            int loops = 0;
            int temp = end;
            for (int current = 0; current < end; ++current) {
                temp = end - current;
                if (!(angle < this.getAngleByAngIndex(temp) && angle < this.getAngleByAngIndex(temp - 1)) && angle != this.getAngleByAngIndex(temp)) continue;
                return this.getAngleByAngIndex(temp);
            }
            return this.getAngleByAngIndex(temp);
        }

        @Override
        public float getAngleByAngIndex(int index) {
            if (index < 0) {
                index = 0;
            }
            if (index > 36) {
                index = 36;
            }
            for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
                if (symbol.angleIndex != index) continue;
                return symbol.angle;
            }
            return 0.0f;
        }

        public SymbolUniverseEnum[] getValues() {
            return SymbolUniverseEnum.values();
        }

        @Override
        public Block getBaseBlock() {
            return (Block)BlockRegistry.STARGATE_UNIVERSE_BASE_BLOCK.get();
        }

        @Override
        public Item getGlyphUpgrade() {
            return (Item)ItemRegistry.CRYSTAL_GLYPH_UNIVERSE.get();
        }

        @Override
        public Block getDHDBlock() {
            return null;
        }

        @Override
        public String getId() {
            return "universe";
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 42;
        }

        @Override
        public SymbolUniverseEnum getRandomSymbol(Random random) {
            int id;
            while (this.valueOf(id = random.nextInt(36) + 1) == null || !this.valueOf(id).isValidForAddress() || id == this.getOrigin().getId()) {
            }
            return this.valueOf(id);
        }

        @Override
        public boolean validateDialedAddress(StargateAddressDynamic stargateAddress) {
            if (stargateAddress.size() < 7) {
                return false;
            }
            return stargateAddress.get(stargateAddress.size() - 1).origin();
        }

        @Override
        public int getMinimalSymbolCountTo(SymbolTypeEnum<?> symbolType, boolean localDial) {
            if (((Boolean)JSGConfig.Stargate.useStrictSevenSymbolsUniGate.get()).booleanValue()) {
                localDial = true;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
                return 9;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
                return 9;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
                return localDial ? 7 : 8;
            }
            return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.UNIVERSE, localDial);
        }

        @Override
        public SymbolUniverseEnum getOrigin() {
            return G17;
        }

        @Override
        public int getMaxSymbolsDisplay(boolean hasUpgrade) {
            return hasUpgrade ? 8 : 6;
        }

        @Override
        public SymbolUniverseEnum getTopSymbol() {
            return TOP_CHEVRON;
        }

        @Override
        public SymbolUniverseEnum valueOf(int id) {
            return ID_MAP.get(id);
        }

        @Override
        public SymbolUniverseEnum fromEnglishName(String englishName) {
            SymbolUniverseEnum symbol = ENGLISH_NAME_MAP.get(englishName.toLowerCase());
            if (symbol != null) {
                return symbol;
            }
            try {
                int index = Integer.parseInt(englishName.replace("G", ""));
                if (index < 1 || index > 36) {
                    return null;
                }
                return SymbolUniverseEnum.values()[index];
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }

        static {
            for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
                ID_MAP.put(symbol.id, symbol);
                ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
            }
            ENGLISH_NAME_MAP.put("point of origin", G17);
        }
    }
}

