/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.effect.StargateWormholeHandler;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.VectorHelper;
import dev.tauri.jsg.integration.create.CreateIntegrationManager;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionAndRotationToClient;
import dev.tauri.jsg.registry.DamageTypeRegistry;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.teleportation.JSGGateTeleporter;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import org.joml.Vector3d;

public class TeleportHelper {
    public static void teleportEntity(Entity entity, BlockPos sourceGatePos, StargatePos targetGatePos, Vector3f mv) {
        StargateAbstractBaseBE sourceTile;
        boolean isCreateEntity;
        StargateAbstractBaseBE targetTile = targetGatePos.getBlockEntity();
        boolean bl = isCreateEntity = !CreateIntegrationManager.canStargateTeleport(entity);
        if (!isCreateEntity) {
            ServerPlayer sp;
            List passengers;
            if (entity.m_20159_()) {
                return;
            }
            if (entity.m_20160_()) {
                passengers = entity.m_20197_();
                entity.m_20153_();
                for (Entity passenger : passengers) {
                    TeleportHelper.teleportEntity(passenger, sourceGatePos, targetGatePos, mv);
                }
            } else {
                passengers = null;
            }
            Level world = entity.m_9236_();
            ResourceKey sourceDim = world.m_46472_();
            BlockEntity sourceBlockEntity = sourceGatePos == null ? null : world.m_7702_(sourceGatePos);
            sourceTile = sourceBlockEntity instanceof StargateAbstractBaseBE ? (StargateAbstractBaseBE)sourceBlockEntity : targetTile;
            Rotation rsh = BlockPosHelper.getRotation(sourceTile.getFacing());
            Rotation rth = BlockPosHelper.getRotation(targetTile.getFacing());
            VectorHelper vectorHelper = new VectorHelper(sourceTile.getFacing(), sourceTile.getFacingVertical(), targetTile.getFacing(), targetTile.getFacingVertical());
            Vec3 relativePosSource = entity.m_20182_().m_82546_(sourceTile.getGateCenterPos().m_252807_());
            relativePosSource = vectorHelper.rotate(relativePosSource, vec -> vec.m_82520_(0.0, 0.0, 1.0));
            relativePosSource = relativePosSource.m_82520_(targetTile.getGateCenterPos().m_252807_().m_7096_(), targetTile.getGateCenterPos().m_252807_().m_7098_(), targetTile.getGateCenterPos().m_252807_().m_7094_());
            if (targetTile instanceof StargateOrlinBaseBE) {
                relativePosSource = targetTile.getGateCenterPos().m_252807_().m_82520_(0.0, -0.7, 0.0);
            }
            Vector3d posFinal = new Vector3d(relativePosSource.m_7096_(), relativePosSource.m_7098_(), relativePosSource.m_7094_());
            Vector3f motionVector = new Vector3f(vectorHelper.rotate(mv.toVec3(), vector -> {
                if (sourceTile.getDialedAddress().size() == 9) {
                    return vector.m_82542_(1.0, 1.0, 2.0).m_82520_(0.0, 0.0, 0.5);
                }
                return vector;
            }));
            float entityYaw = entity.m_146908_();
            float newYaw = entityYaw - (float)BlockPosHelper.getDegrees(rsh) + (float)BlockPosHelper.getDegrees(rth) + 180.0f;
            StargateClassicBaseBE targetGateClassic = targetGatePos.getBlockEntity() instanceof StargateClassicBaseBE ? (StargateClassicBaseBE)targetGatePos.getBlockEntity() : null;
            boolean targetIrisClosed = targetGateClassic != null && targetGateClassic.isIrisClosed();
            boolean isProjectile = entity instanceof Projectile;
            boolean irisKillAtDestination = (Boolean)JSGConfig.Stargate.killAtDestination.get();
            boolean irisDoNotKillCreative = (Boolean)JSGConfig.Stargate.allowCreative.get();
            boolean isEntityCreative = entity instanceof ServerPlayer && (sp = (ServerPlayer)entity).m_7500_();
            boolean killEntityPre = false;
            boolean killEntityPost = false;
            if (targetIrisClosed) {
                if (isProjectile) {
                    entity.m_20334_(0.0, 0.0, 0.0);
                    entity.m_6074_();
                    targetGateClassic.hitIris();
                } else if (!irisDoNotKillCreative || !isEntityCreative) {
                    if (irisKillAtDestination) {
                        killEntityPost = true;
                    } else {
                        killEntityPre = true;
                    }
                }
            }
            boolean finalKillEntityPost = killEntityPost;
            if (killEntityPre) {
                targetGateClassic.hitIris();
                TeleportHelper.irisKill(entity);
            } else if (sourceDim == targetGatePos.dimension) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp2 = (ServerPlayer)entity;
                    TeleportHelper.setRotationAndPositionAndMotion(entity, newYaw, posFinal, new Vector3f(0.0f, 0.0f, 0.0f), false);
                    StargateWormholeHandler.handle(sp2, () -> {
                        if (finalKillEntityPost) {
                            targetGateClassic.hitIris();
                        }
                        TeleportHelper.setRotationAndPositionAndMotion(entity, newYaw, posFinal, motionVector, finalKillEntityPost);
                        targetTile.entityPassing(entity, true, false);
                    }, StargateWormholeType.fromTileEntity(targetTile), 1);
                } else {
                    if (finalKillEntityPost) {
                        targetGateClassic.hitIris();
                    }
                    TeleportHelper.setRotationAndPositionAndMotion(entity, newYaw, posFinal, motionVector, finalKillEntityPost);
                    targetTile.entityPassing(entity, true, false);
                }
                if (passengers != null && !finalKillEntityPost) {
                    for (Entity passenger : passengers) {
                        passenger.m_20329_(entity);
                    }
                }
            } else {
                if (!TeleportHelper.fireTravelToDimEvent(entity, targetGatePos.dimension)) {
                    return;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp3 = (ServerPlayer)entity;
                    StargateWormholeHandler.handle(sp3, () -> {
                        entity.changeDimension(Objects.requireNonNull(Objects.requireNonNull(entity.m_20194_()).m_129880_(targetGatePos.dimension)), (ITeleporter)new JSGGateTeleporter(posFinal, motionVector, newYaw, passengers, finalKillEntityPost, targetGateClassic));
                        targetTile.entityPassing(entity, true, false);
                    }, StargateWormholeType.fromTileEntity(targetTile), 3);
                } else {
                    entity.changeDimension(Objects.requireNonNull(Objects.requireNonNull(entity.m_20194_()).m_129880_(targetGatePos.dimension)), (ITeleporter)new JSGGateTeleporter(posFinal, motionVector, newYaw, passengers, killEntityPost, targetGateClassic));
                    targetTile.entityPassing(entity, true, false);
                }
            }
        } else {
            sourceTile = targetTile;
        }
        sourceTile.entityPassing(entity, false, isCreateEntity);
        if (isCreateEntity) {
            targetTile.entityPassing(entity, true, true);
            CreateIntegrationManager.markPassengersAsTeleported(entity, targetTile);
        }
    }

    public static void irisKill(Entity e) {
        if (!(e instanceof LivingEntity)) {
            e.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        DamageTypeRegistry.killEntity(e, DamageTypeRegistry.IRIS);
    }

    public static void kawooshKill(Entity e) {
        if (!(e instanceof LivingEntity)) {
            e.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (e instanceof ServerPlayer) {
            JSGAdvancements.KAWOOSH_CREMATION.trigger((ServerPlayer)e);
        }
        DamageTypeRegistry.killEntity(e, DamageTypeRegistry.KAWOOSH);
    }

    public static void wrongSideKill(Entity e) {
        if (!(e instanceof LivingEntity)) {
            e.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        DamageTypeRegistry.killEntity(e, DamageTypeRegistry.WRONG_SIDE);
    }

    public static void unstableEhKill(Entity e) {
        if (!(e instanceof LivingEntity)) {
            e.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        DamageTypeRegistry.killEntity(e, DamageTypeRegistry.UNSTABLE_EH);
    }

    public static void teleportEntityToStargate(Entity entity, StargatePos targetGatePos, boolean bypassCancelEvent) {
        if (entity.m_20159_()) {
            return;
        }
        if (entity.m_20160_()) {
            entity.m_20153_();
        }
        Level world = entity.m_9236_();
        ResourceKey sourceDim = world.m_46472_();
        StargateAbstractBaseBE targetTile = targetGatePos.getBlockEntity();
        BlockPos tPos = targetTile.getGateCenterPos().m_121955_(targetTile.getFacing().m_122436_()).m_121955_(targetTile.getFacingVertical().m_122436_());
        Vector3d pos = new Vector3d((double)tPos.m_123341_(), (double)tPos.m_123342_(), (double)tPos.m_123343_());
        if (sourceDim == targetGatePos.dimension) {
            TeleportHelper.setRotationAndPositionAndMotion(entity, entity.m_6080_(), pos, new Vector3f(), false);
        } else {
            if (!TeleportHelper.fireTravelToDimEvent(entity, targetGatePos.dimension) && !bypassCancelEvent) {
                return;
            }
            entity.changeDimension(Objects.requireNonNull(Objects.requireNonNull(entity.m_20194_()).m_129880_(targetGatePos.dimension)), (ITeleporter)new JSGGateTeleporter(pos, new Vector3f(), entity.m_146908_(), null, false, null));
        }
    }

    public static boolean fireTravelToDimEvent(Entity entity, ResourceKey<Level> dimension) {
        if (!(entity instanceof Player)) {
            return true;
        }
        Player p = (Player)entity;
        return ForgeHooks.onTravelToDimension((Entity)entity, dimension);
    }

    public static void setRotationAndPositionAndMotion(Entity entity, float yawRotated, Vector3d pos, Vector3f motion, boolean killWhenPlaced) {
        entity.m_6021_(pos.x, pos.y, pos.z);
        entity.m_5616_(yawRotated);
        if (motion != null) {
            Vec3 v = new Vec3((double)motion.x, (double)motion.y, (double)motion.z);
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity;
                JSGPacketHandler.sendTo(new StargateMotionAndRotationToClient(v, entity.m_146909_(), yawRotated), sp);
            } else if (entity instanceof AbstractMinecart && v.m_7098_() < 0.0) {
                entity.m_20256_(new Vec3(0.0, 0.0, 0.0));
            } else if (entity instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile fireball = (AbstractHurtingProjectile)entity;
                fireball.m_20256_(v);
                fireball.f_36813_ = (double)motion.getX() * 0.1;
                fireball.f_36814_ = (double)motion.getY() * 0.1;
                fireball.f_36815_ = (double)motion.getZ() * 0.1;
            } else {
                entity.m_20256_(v);
            }
        }
        if (killWhenPlaced) {
            TeleportHelper.irisKill(entity);
        }
    }

    public static boolean frontSide(Direction sourceFacing, Vector3f motionVec) {
        Direction.Axis axis = sourceFacing.m_122434_();
        Direction.AxisDirection direction = sourceFacing.m_122421_();
        float motion = axis == Direction.Axis.X ? motionVec.x : (axis == Direction.Axis.Y ? motionVec.y : motionVec.z);
        if (direction == Direction.AxisDirection.POSITIVE) {
            return motion <= 0.0f;
        }
        return motion >= 0.0f;
    }
}

