/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.state.stargate;

import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.state.State;
import io.netty.buffer.ByteBuf;

public class StargateSpinState
extends State {
    public SymbolInterface targetSymbol;
    public EnumSpinDirection direction;
    public boolean setOnly;
    public int plusRounds;

    public StargateSpinState() {
    }

    public StargateSpinState(SymbolInterface targetSymbol, EnumSpinDirection direction, boolean setOnly, int plusRounds) {
        this.targetSymbol = targetSymbol;
        this.direction = direction;
        this.setOnly = setOnly;
        this.plusRounds = plusRounds;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(SymbolTypeEnum.getId(this.targetSymbol.getSymbolType()));
        buf.writeInt(this.targetSymbol.getId());
        buf.writeInt(this.direction.id);
        buf.writeBoolean(this.setOnly);
        buf.writeInt(this.plusRounds);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        SymbolTypeEnum<?> symbolType = SymbolTypeEnum.byId(buf.readInt());
        this.targetSymbol = symbolType.valueOf(buf.readInt());
        this.direction = EnumSpinDirection.valueOf(buf.readInt());
        this.setOnly = buf.readBoolean();
        this.plusRounds = buf.readInt();
    }
}

