/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class I18n {
    public static String format(String s) {
        return Component.m_237115_((String)s).getString();
    }

    public static String format(String s, Object ... pArgs) {
        return Component.m_237110_((String)s, (Object[])pArgs).getString();
    }

    public static AdvancedTooltip getAdvancedTooltip(String s, ILineFormat lineFormat) {
        return new AdvancedTooltip(s, lineFormat);
    }

    public static class AdvancedTooltip {
        public String key;
        public ILineFormat lineFormatting;

        public AdvancedTooltip(String key, ILineFormat lineFormatting) {
            this.key = key;
            this.lineFormatting = lineFormatting;
        }

        public int getWidth() {
            List<Component> l = this.formatLines();
            int textWidth = 0;
            for (Component c : l) {
                int ii = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c);
                if (ii <= textWidth) continue;
                textWidth = ii;
            }
            int spaceWidth = Minecraft.m_91087_().f_91062_.m_92895_(" ");
            return (int)Math.ceil((double)textWidth / (double)spaceWidth);
        }

        public List<Component> formatLines() {
            String text = I18n.format(this.key);
            String[] lines = text.split("%nl%");
            ArrayList<Component> linesC = new ArrayList<Component>();
            int i = 0;
            for (String line : lines) {
                linesC.add((Component)this.lineFormatting.apply(++i, Component.m_237113_((String)(" " + line))));
            }
            if (lines.length > 0 && lines[0].equals(this.key)) {
                return null;
            }
            return linesC;
        }
    }

    public static interface ILineFormat {
        public MutableComponent apply(int var1, MutableComponent var2);
    }
}

