/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig.classes;

import com.codinglitch.lexiconfig.LexiconfigApi;
import com.codinglitch.lexiconfig.classes.LexiconEntryData;
import com.codinglitch.lexiconfig.classes.LexiconPageData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class LexiconSubstrate {
    Map<String, LexiconEntryData<?>> ENTRIES = new HashMap();

    public List<LexiconEntryData<?>> getContents(Predicate<LexiconEntryData<?>> criteria) {
        ArrayList entries = new ArrayList();
        for (Map.Entry<String, LexiconEntryData<?>> entry : this.ENTRIES.entrySet()) {
            if (!criteria.test(entry.getValue())) continue;
            entries.add(entry.getValue());
        }
        return entries;
    }

    public <T> Optional<LexiconEntryData<T>> getEntryData(String name) {
        LexiconEntryData<?> entry = this.ENTRIES.get(name);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public <T> Optional<T> getEntry(String name) {
        LexiconEntryData entry = this.getEntryData(name).orElse(null);
        if (entry == null) {
            return Optional.empty();
        }
        return entry.get();
    }

    public <T> void setEntry(String name, T value) {
        LexiconEntryData entry = this.getEntryData(name).orElse(null);
        if (entry == null) {
            return;
        }
        entry.set(value);
    }

    public void catalog() {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                Object value = field.get(this);
                this.ENTRIES.put(field.getName(), new LexiconEntryData<Object>(field, this, value));
                if (!(value instanceof LexiconSubstrate)) continue;
                LexiconSubstrate substrate = (LexiconSubstrate)value;
                substrate.catalog();
            }
            catch (IllegalAccessException e) {
                LexiconfigApi.warn(e, new Object[0]);
            }
        }
    }

    public Optional<Integer> getInt(String name) {
        return this.getEntry(name);
    }

    public Optional<Float> getFloat(String name) {
        return this.getEntry(name);
    }

    public Optional<Double> getDouble(String name) {
        return this.getEntry(name);
    }

    public Optional<String> getString(String name) {
        return this.getEntry(name);
    }

    public Optional<LexiconPageData> getPage(String name) {
        return this.getEntry(name);
    }
}

