/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.api.data.objects.EmissiveArmorTrimTexture;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class ArmorTrimLightingRegistry {
    private static final Map<ResourceKey<TrimMaterial>, Integer> REGISTRY = new HashMap<ResourceKey<TrimMaterial>, Integer>();

    public void register(EmissiveArmorTrimTexture emissiveTexture) {
        ResourceKey<TrimMaterial> trimMaterial = emissiveTexture.trimMaterial();
        int light = emissiveTexture.light();
        if (light <= -1) {
            this.remove(trimMaterial);
        } else {
            REGISTRY.put(trimMaterial, light);
            if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [" + trimMaterial.m_135782_() + "] set to " + light, new Object[0]);
            }
        }
    }

    public void register(ResourceKey<TrimMaterial> trimMaterial, int lightLevel) {
        this.register(new EmissiveArmorTrimTexture(trimMaterial, lightLevel));
    }

    public void remove(ResourceKey<TrimMaterial> trimMaterial) {
        if (REGISTRY.remove(trimMaterial) != null && ((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> Removed [" + trimMaterial.m_135782_() + "]", new Object[0]);
        }
    }

    public static int get(ResourceKey<TrimMaterial> trimMaterial) {
        Integer light = REGISTRY.get(trimMaterial);
        return light != null ? light : 0;
    }

    public static int get(ArmorTrim armorTrim) {
        return armorTrim.m_266210_().m_203543_().map(ArmorTrimLightingRegistry::get).orElse(0);
    }

    @Deprecated
    public static void clear() {
        REGISTRY.clear();
    }
}

