/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.util;

import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraLogisticalTransporter;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ExtraTransporterUtils {
    public static final List<EnumColor> colors = List.of(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    private ExtraTransporterUtils() {
    }

    @Nullable
    public static EnumColor readColor(int inputColor) {
        return inputColor == -1 ? null : (EnumColor)TransporterUtils.colors.get(inputColor);
    }

    public static int getColorIndex(@Nullable EnumColor color) {
        return color == null ? -1 : TransporterUtils.colors.indexOf(color);
    }

    public static void drop(LogisticalTransporterBase transporter, TransporterStack stack) {
        BlockPos blockPos = transporter.getTilePos();
        if (stack.hasPath()) {
            float[] pos = ExtraTransporterUtils.getStackPosition(transporter, stack, 0.0f);
            blockPos = blockPos.m_7918_(Mth.m_14143_((float)pos[0]), Mth.m_14143_((float)pos[1]), Mth.m_14143_((float)pos[2]));
        }
        TransporterManager.remove((Level)transporter.getTileWorld(), (TransporterStack)stack);
        Block.m_49840_((Level)transporter.getTileWorld(), (BlockPos)blockPos, (ItemStack)stack.itemStack);
    }

    public static float[] getStackPosition(LogisticalTransporterBase transporter, TransporterStack stack, float partial) {
        Direction side = stack.getSide(transporter);
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        return new float[]{0.5f + (float)side.m_122429_() * progress, 0.25f + (float)side.m_122430_() * progress, 0.5f + (float)side.m_122431_() * progress};
    }

    public static void incrementColor(ExtraLogisticalTransporter tile) {
        EnumColor color = tile.getColor();
        if (color == null) {
            tile.setColor(colors.get(0));
        } else {
            int index = colors.indexOf(color);
            if (index == colors.size() - 1) {
                tile.setColor(null);
            } else {
                tile.setColor(colors.get(index + 1));
            }
        }
    }
}

