/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block_entity;

import com.github.x3r.mekanism_turrets.common.capability.MTEnergyStorage;
import com.github.x3r.mekanism_turrets.common.registry.BlockEntityTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.BlockRegistry;
import java.util.Optional;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricFenceBlockEntity
extends TileEntityMekanism {
    private final LazyOptional<MTEnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> new MTEnergyStorage(1000, 1000, 10000));

    public ElectricFenceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockRegistry.ELECTRIC_FENCE, pPos, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ElectricFenceBlockEntity blockEntity) {
        for (Direction dir : Direction.values()) {
            blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(ownStorage -> {
                Optional otherBlockEntity = pLevel.m_141902_(pPos.m_121945_(dir), (BlockEntityType)BlockEntityTypeRegistry.ELECTRIC_FENCE.get());
                otherBlockEntity.ifPresent(electricFenceBlockEntity -> electricFenceBlockEntity.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(otherStorage -> {
                    if (ownStorage.getEnergyStored() > otherStorage.getEnergyStored() && otherStorage.getEnergyStored() < otherStorage.getMaxEnergyStored()) {
                        int a = ownStorage.extractEnergy(750, true);
                        int b = otherStorage.receiveEnergy(750, true);
                        ownStorage.extractEnergy(otherStorage.receiveEnergy(Math.min(a, b), false), false);
                    }
                }));
            });
        }
        blockEntity.markUpdated();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorageLazyOptional.ifPresent(energyStorage -> energyStorage.deserializeNBT(tag));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.energyStorageLazyOptional.ifPresent(energyStorage -> tag.m_128365_("EnergyStorage", (Tag)energyStorage.serializeNBT()));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ENERGY)) {
            return this.energyStorageLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageLazyOptional.invalidate();
    }

    protected void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

