/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.EventForceManipulate;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.api.security.InterdictionMatrix;
import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.setup.ModBlocks;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.Fortron;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.loot.GuideBookTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeEventHandler {
    @SubscribeEvent
    public static void serverStarting(ServerStartingEvent event) {
        FrequencyGrid.reinitiate();
    }

    @SubscribeEvent
    public static void eventPreForceManipulate(EventForceManipulate.EventPreForceManipulate event) {
        BlockEntity be = event.getLevel().m_7702_(event.getBeforePos());
        if (be instanceof FortronBlockEntity) {
            FortronBlockEntity fortronBlockEntity = (FortronBlockEntity)be;
            fortronBlockEntity.setMarkSendFortron(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ForgeEventHandler.onPlayerInteract((PlayerInteractEvent)event, Fortron.Action.RIGHT_CLICK_BLOCK);
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().m_8055_(event.getPos()).m_60713_((Block)ModBlocks.FORCE_FIELD.get())) {
            event.setCanceled(true);
        } else {
            ForgeEventHandler.onPlayerInteract((PlayerInteractEvent)event, Fortron.Action.LEFT_CLICK_BLOCK);
        }
    }

    @SubscribeEvent
    public static void livingSpawnEvent(MobSpawnEvent event) {
        InterdictionMatrix interdictionMatrix = Fortron.getNearestInterdictionMatrix(event.getEntity().m_9236_(), BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ()));
        if (interdictionMatrix != null && interdictionMatrix.hasModule(ModModules.ANTI_SPAWN)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (((Boolean)MFFSConfig.COMMON.giveGuidebookOnFirstJoin.get()).booleanValue()) {
                ((GuideBookTrigger)((Object)ModObjects.GUIDEBOOK_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    private static void onPlayerInteract(PlayerInteractEvent event, Fortron.Action action) {
        BlockPos pos;
        Level level;
        InterdictionMatrix interdictionMatrix;
        Player player = event.getEntity();
        if (!player.m_7500_() && (interdictionMatrix = Fortron.getNearestInterdictionMatrix(level = event.getLevel(), pos = event.getPos())) != null) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60713_((Block)ModBlocks.BIOMETRIC_IDENTIFIER.get()) && Fortron.isPermittedByInterdictionMatrix(interdictionMatrix, player, FieldPermission.CONFIGURE_SECURITY_CENTER)) {
                return;
            }
            if (!Fortron.hasPermission(level, pos, interdictionMatrix, action, player)) {
                player.m_5661_((Component)ModUtil.translate("info", "interdiction_matrix.no_permission", interdictionMatrix.getTitle()), false);
                event.setCanceled(true);
            }
        }
    }
}

