/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class DisintegrationModule
extends BaseModule {
    private final List<BlockPos> activeBlocks = new ArrayList<BlockPos>();

    public DisintegrationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public Module.ProjectAction onSelect(Projector projector, BlockPos pos) {
        Level level;
        BlockState state;
        if (!this.activeBlocks.contains(pos) && !(state = (level = projector.be().m_58904_()).m_8055_(pos)).m_60795_()) {
            Block block = state.m_60734_();
            if (projector.hasModule(ModModules.CAMOUFLAGE)) {
                Item blockItem = block.m_5456_();
                if (projector.getAllModuleItemsStream().noneMatch(stack -> ProjectorBlockEntity.getFilterBlock(stack).isPresent() && stack.m_150930_(blockItem))) {
                    return Module.ProjectAction.SKIP;
                }
            }
            if (!state.m_204336_(ModTags.DISINTEGRATION_BLACKLIST) && !ModUtil.isLiquidBlock(block)) {
                if (this.activeBlocks.size() - 1 >= projector.getModuleCount(ModModules.SPEED) / 3) {
                    return Module.ProjectAction.INTERRUPT;
                }
                this.activeBlocks.add(pos);
                return Module.ProjectAction.PROJECT;
            }
        }
        return Module.ProjectAction.SKIP;
    }

    @Override
    public Module.ProjectAction onProject(Projector projector, BlockPos position) {
        Level level = projector.be().m_58904_();
        BlockState state = level.m_8055_(position);
        Vec3 pos = Vec3.m_82528_((Vec3i)projector.be().m_58899_());
        Vec3 target = Vec3.m_82528_((Vec3i)position);
        Network.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(position)), (Object)new DrawHologramPacket(pos, target, DrawHologramPacket.Type.DESTROY));
        projector.schedule(39, () -> {
            if (projector.hasModule(ModModules.COLLECTION)) {
                DisintegrationModule.collectBlock(projector, level, position, state.m_60734_());
            } else {
                DisintegrationModule.destroyBlock(level, position, state.m_60734_());
            }
            this.activeBlocks.remove(position);
        });
        return Module.ProjectAction.SKIP;
    }

    private static void destroyBlock(Level level, BlockPos pos, Block block) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(block)) {
            Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_7471_(pos, false);
        }
    }

    private static void collectBlock(Projector projector, Level level, BlockPos pos, Block block) {
        BlockState state = level.m_8055_(pos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.m_60713_(block)) {
                Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos)).forEach(projector::mergeIntoInventory);
                level.m_7471_(pos, false);
            }
        }
    }
}

