/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CubeProjectorMode
implements ProjectorMode {
    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        int y;
        int x;
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        for (x = -negScale.m_123341_(); x <= posScale.m_123341_(); ++x) {
            for (int z = -negScale.m_123343_(); z <= posScale.m_123343_(); ++z) {
                fieldBlocks.add(new Vec3((double)x, (double)posScale.m_123342_(), (double)z));
                fieldBlocks.add(new Vec3((double)x, (double)(-negScale.m_123342_()), (double)z));
            }
        }
        for (x = -negScale.m_123341_(); x <= posScale.m_123341_(); ++x) {
            for (y = -negScale.m_123342_(); y <= posScale.m_123342_(); ++y) {
                fieldBlocks.add(new Vec3((double)x, (double)y, (double)posScale.m_123343_()));
                fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-negScale.m_123343_())));
            }
        }
        for (int z = -negScale.m_123343_(); z <= posScale.m_123343_(); ++z) {
            for (y = -negScale.m_123342_(); y <= posScale.m_123342_(); ++y) {
                fieldBlocks.add(new Vec3((double)posScale.m_123341_(), (double)y, (double)z));
                fieldBlocks.add(new Vec3((double)(-negScale.m_123341_()), (double)y, (double)z));
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        for (int x = -negScale.m_123341_(); x <= posScale.m_123341_(); ++x) {
            for (int z = -negScale.m_123343_(); z <= posScale.m_123343_(); ++z) {
                for (int y = -negScale.m_123342_(); y <= posScale.m_123342_(); ++y) {
                    fieldBlocks.add(new Vec3((double)x, (double)y, (double)z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        BlockPos projectorPos = projector.be().m_58899_().m_121955_((Vec3i)projector.getTranslation());
        Vec3 relativePosition = position.m_82492_((double)projectorPos.m_123341_(), (double)projectorPos.m_123342_(), (double)projectorPos.m_123343_());
        Vec3 rotated = ModUtil.rotateByAngleExact(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch(), -projector.getRotationRoll());
        AABB region = new AABB(projector.getNegativeScale().m_142393_(-1).m_7918_(1, 1, 1), projector.getPositiveScale());
        return region.m_82393_(rotated.m_7096_(), rotated.m_7098_(), rotated.m_7094_());
    }
}

