/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.s2c.CustomSkinsChangedMessage;
import forge.net.mca.resources.data.skin.Clothing;
import forge.net.mca.resources.data.skin.Hair;
import forge.net.mca.resources.data.skin.SkinListEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class CustomClothingManager {
    static final Storage<Clothing> CLOTHING_DUMMY = new Storage();
    static final Storage<Hair> HAIR_DUMMY = new Storage();

    public static Storage<Clothing> getClothing() {
        Optional<MinecraftServer> server = MCA.getServer();
        if (server.isPresent()) {
            return (Storage)server.get().m_129783_().m_8895_().m_164861_(nbt -> new Storage<Clothing>((CompoundTag)nbt, Clothing::new), Storage::new, "immersive_library_clothing");
        }
        return CLOTHING_DUMMY;
    }

    public static Storage<Hair> getHair() {
        Optional<MinecraftServer> server = MCA.getServer();
        if (server.isPresent()) {
            return (Storage)server.get().m_129783_().m_8895_().m_164861_(nbt -> new Storage<Hair>((CompoundTag)nbt, Hair::new), Storage::new, "immersive_library_hair");
        }
        return HAIR_DUMMY;
    }

    public static class Storage<T extends SkinListEntry>
    extends SavedData {
        final Map<String, T> entries = new HashMap<String, T>();

        public Storage() {
        }

        public Storage(CompoundTag nbt, BiFunction<String, JsonObject, T> entryFromNbt) {
            Gson gson = new Gson();
            for (String identifier : nbt.m_128431_()) {
                this.entries.put(identifier, (SkinListEntry)entryFromNbt.apply(identifier, (JsonObject)gson.fromJson(nbt.m_128461_(identifier), JsonObject.class)));
            }
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            CompoundTag c = new CompoundTag();
            for (Map.Entry<String, T> entry : this.entries.entrySet()) {
                c.m_128359_(entry.getKey(), ((SkinListEntry)entry.getValue()).toJson().toString());
            }
            return c;
        }

        public Map<String, T> getEntries() {
            return this.entries;
        }

        public void addEntry(String id, T entry) {
            this.entries.put(id, entry);
            this.m_77762_();
        }

        public void removeEntry(String id) {
            this.entries.remove(id);
            this.m_77762_();
        }

        public void m_77762_() {
            super.m_77762_();
            MCA.getServer().ifPresent(s -> {
                for (ServerPlayer player : s.m_6846_().m_11314_()) {
                    NetworkHandler.sendToPlayer(new CustomSkinsChangedMessage(), player);
                }
            });
        }
    }
}

