/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.registry;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import umpaz.nethersdelight.common.block.BlackstoneBlastFurnaceBlock;
import umpaz.nethersdelight.common.block.BlackstoneFurnaceBlock;
import umpaz.nethersdelight.common.block.BlackstoneStoveBlock;
import umpaz.nethersdelight.common.block.FungusColonyBlock;
import umpaz.nethersdelight.common.block.HoglinMountBlock;
import umpaz.nethersdelight.common.block.MimicarnationBlock;
import umpaz.nethersdelight.common.block.NetherBrickSmokerBlock;
import umpaz.nethersdelight.common.block.PropelplantBerryCaneBlock;
import umpaz.nethersdelight.common.block.PropelplantBerryStemBlock;
import umpaz.nethersdelight.common.block.PropelplantCaneBlock;
import umpaz.nethersdelight.common.block.PropelplantStemBlock;
import umpaz.nethersdelight.common.block.RichSoulSoilBlock;
import umpaz.nethersdelight.common.block.SoulCompostBlock;
import umpaz.nethersdelight.common.block.StuffedHoglinBlock;

public class NDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nethersdelight");
    public static final RegistryObject<Block> BLACKSTONE_STOVE = BLOCKS.register("blackstone_stove", () -> new BlackstoneStoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50735_).m_60953_(NDBlocks.stoveBlockEmission(13, 9))));
    public static final RegistryObject<Block> BLACKSTONE_FURNACE = BLOCKS.register("blackstone_furnace", () -> new BlackstoneFurnaceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_).m_60999_().m_60978_(3.5f).m_60953_(NDBlocks.furnaceBlockEmission(13))));
    public static final RegistryObject<Block> NETHER_BRICK_SMOKER = BLOCKS.register("nether_brick_smoker", () -> new NetherBrickSmokerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50197_).m_60999_().m_60978_(3.5f).m_60953_(NDBlocks.furnaceBlockEmission(13))));
    public static final RegistryObject<Block> BLACKSTONE_BLAST_FURNACE = BLOCKS.register("blackstone_blast_furnace", () -> new BlackstoneBlastFurnaceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50734_).m_60999_().m_60978_(3.5f).m_60953_(NDBlocks.furnaceBlockEmission(13))));
    public static final RegistryObject<Block> HOGLIN_TROPHY = BLOCKS.register("hoglin_trophy", () -> new HoglinMountBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50100_)));
    public static final RegistryObject<Block> STUFFED_HOGLIN = BLOCKS.register("stuffed_hoglin", () -> new StuffedHoglinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> CRIMSON_FUNGUS_COLONY = BLOCKS.register("crimson_fungus_colony", () -> new FungusColonyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50700_).m_60977_(), () -> Items.f_41954_));
    public static final RegistryObject<Block> WARPED_FUNGUS_COLONY = BLOCKS.register("warped_fungus_colony", () -> new FungusColonyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50691_).m_60977_(), () -> Items.f_41955_));
    public static final RegistryObject<Block> SOUL_COMPOST = BLOCKS.register("soul_compost", () -> new SoulCompostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50136_).m_60978_(1.2f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<Block> RICH_SOUL_SOIL = BLOCKS.register("rich_soul_soil", () -> new RichSoulSoilBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50136_).m_60977_()));
    private static final BlockBehaviour.Properties mimicarnationBlockBehaviour = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_60953_(state -> 8);
    public static final RegistryObject<Block> MIMICARNATION = BLOCKS.register("mimicarnation", () -> new MimicarnationBlock(MobEffects.f_19609_, 8, mimicarnationBlockBehaviour));
    public static final RegistryObject<Block> POTTED_MIMICARNATION = BLOCKS.register("potted_mimicarnation", () -> new FlowerPotBlock(null, MIMICARNATION, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_).m_284180_(MapColor.f_283915_)));
    private static final BlockBehaviour.Properties propelplantBlockBehaviour = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_278166_(PushReaction.DESTROY).m_60910_().m_60918_(SoundType.f_56740_).m_60978_(0.1f);
    private static final BlockBehaviour.Properties propelplantBerryBlockBehaviour = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_278166_(PushReaction.DESTROY).m_60910_().m_60918_(SoundType.f_56740_).m_60978_(0.1f).m_60953_(NDBlocks.propelplantBlockEmission(9));
    public static final RegistryObject<Block> PROPELPLANT_STEM = BLOCKS.register("propelplant_stem", () -> new PropelplantStemBlock(propelplantBlockBehaviour));
    public static final RegistryObject<Block> PROPELPLANT_BERRY_STEM = BLOCKS.register("propelplant_berry_stem", () -> new PropelplantBerryStemBlock(propelplantBerryBlockBehaviour));
    public static final RegistryObject<Block> PROPELPLANT_CANE = BLOCKS.register("propelplant_cane", () -> new PropelplantCaneBlock(propelplantBlockBehaviour));
    public static final RegistryObject<Block> PROPELPLANT_BERRY_CANE = BLOCKS.register("propelplant_berry_cane", () -> new PropelplantBerryCaneBlock(propelplantBerryBlockBehaviour));
    public static final RegistryObject<Block> PROPELPLANT_TORCH = BLOCKS.register("propelplant_torch", () -> new TorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).m_60953_(light -> 12), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> PROPELPLANT_WALL_TORCH = BLOCKS.register("propelplant_wall_torch", () -> new WallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).lootFrom(PROPELPLANT_TORCH).m_60953_(light -> 12), (ParticleOptions)ParticleTypes.f_123744_));

    public static ToIntFunction<BlockState> stoveBlockEmission(int lightValue, int soulLightValue) {
        return state -> {
            if (((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue()) {
                return soulLightValue;
            }
            if (!((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                return lightValue;
            }
            return 0;
        };
    }

    public static ToIntFunction<BlockState> furnaceBlockEmission(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    public static ToIntFunction<BlockState> propelplantBlockEmission(int pearl) {
        return state -> {
            if (((Boolean)state.m_61143_((Property)PropelplantBerryStemBlock.PEARL)).booleanValue()) {
                return pearl;
            }
            return 0;
        };
    }
}

