/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client;

import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.client.core.registry.SimpleRadioModels;
import com.codinglitch.simpleradio.client.core.registry.models.InsulatorModel;
import com.codinglitch.simpleradio.client.core.registry.models.MicrophoneModel;
import com.codinglitch.simpleradio.client.core.registry.models.RadioModel;
import com.codinglitch.simpleradio.client.core.registry.renderers.FrequencerRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.InsulatorRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.MicrophoneRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.RadioRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.ReceiverRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.TransmitterRenderer;
import com.codinglitch.simpleradio.client.core.registry.renderers.WireRenderer;
import com.codinglitch.simpleradio.client.core.registry.screens.RadiosmitherScreen;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.codinglitch.simpleradio.core.registry.SimpleRadioParticles;
import com.codinglitch.simpleradio.core.registry.particles.ListenParticle;
import com.codinglitch.simpleradio.core.registry.particles.SpeakLineParticle;
import com.codinglitch.simpleradio.core.registry.particles.SpeakRingParticle;
import com.codinglitch.simpleradio.platform.ClientServices;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public class CommonSimpleRadioClient {
    public static final Map<UUID, Boolean> isTransmitting = new HashMap<UUID, Boolean>();

    public static void loadProperties(TriConsumer<Item, ResourceLocation, ClampedItemPropertyFunction> registry) {
        registry.accept((Object)SimpleRadioItems.TRANSCEIVER, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        registry.accept((Object)SimpleRadioItems.TRANSCEIVER, (Object)new ResourceLocation("speaking"), (stack, level, entity, i) -> {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("user")) {
                return 0.0f;
            }
            UUID uuid = tag.m_128342_("user");
            RadioReceiver receiver = ClientRadioManager.getReceiver(uuid);
            if (receiver == null) {
                return 0.0f;
            }
            return receiver.activityTime > 0 ? 1.0f : 0.0f;
        });
        registry.accept((Object)SimpleRadioItems.WALKIE_TALKIE, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        registry.accept((Object)SimpleRadioItems.SPUDDIE_TALKIE, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public static void loadRenderTypes(BiConsumer<Block, RenderType> registry) {
        registry.accept((Object)SimpleRadioBlocks.RADIOSMITHER, (Object)RenderType.m_110463_());
        registry.accept((Object)SimpleRadioBlocks.ANTENNA, (Object)RenderType.m_110463_());
        registry.accept((Object)SimpleRadioBlocks.RECEIVER, (Object)RenderType.m_110463_());
    }

    public static void loadLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> registry) {
        registry.accept((Object)RadioModel.LAYER_LOCATION, RadioModel::createBodyLayer);
        registry.accept((Object)MicrophoneModel.LAYER_LOCATION, MicrophoneModel::createBodyLayer);
        registry.accept((Object)InsulatorModel.LAYER_LOCATION, InsulatorModel::createBodyLayer);
    }

    public static void loadBlockEntityRenderers(BlockEntityRendererRegistry registry) {
        registry.register(SimpleRadioBlockEntities.RADIO, RadioRenderer::new);
        registry.register(SimpleRadioBlockEntities.FREQUENCER, FrequencerRenderer::new);
        registry.register(SimpleRadioBlockEntities.MICROPHONE, MicrophoneRenderer::new);
        registry.register(SimpleRadioBlockEntities.INSULATOR, InsulatorRenderer::new);
        registry.register(SimpleRadioBlockEntities.TRANSMITTER, TransmitterRenderer::new);
        registry.register(SimpleRadioBlockEntities.RECEIVER, ReceiverRenderer::new);
    }

    public static void loadEntityRenderers(EntityRendererRegistry registry) {
        registry.register(SimpleRadioEntities.WIRE, WireRenderer::new);
    }

    public static void loadScreens() {
        ClientServices.REGISTRY.registerScreen(SimpleRadioMenus.RADIOSMITHER_MENU, RadiosmitherScreen::new);
    }

    public static void loadParticles(ParticleProviderRegistry registry) {
        registry.register(SimpleRadioParticles.SPEAK_RING, SpeakRingParticle.Provider::new);
        registry.register(SimpleRadioParticles.SPEAK_LINE, SpeakLineParticle.Provider::new);
        registry.register(SimpleRadioParticles.LISTEN, ListenParticle.Provider::new);
    }

    public static void loadAtlases(BiConsumer<ResourceLocation, Supplier<LayerDefinition>> registry) {
    }

    public static void initialize() {
        SimpleRadioModels.load();
    }

    public static interface BlockEntityRendererRegistry {
        public <BE extends BlockEntity> void register(BlockEntityType<BE> var1, BlockEntityRendererProvider<? super BE> var2);
    }

    public static interface EntityRendererRegistry {
        public <E extends Entity> void register(EntityType<? extends E> var1, EntityRendererProvider<? super E> var2);
    }

    @FunctionalInterface
    public static interface ParticleProviderRegistry {
        public <O extends ParticleOptions> void register(ParticleType<O> var1, ParticleEngine.SpriteParticleRegistration<O> var2);
    }
}

