/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.networking;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.client.core.SimpleRadioClientNetworking;
import com.codinglitch.simpleradio.core.networking.CustomPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundActivityPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRegisterRouterPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundSpeakSoundPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundWireEffectPacket;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRadioUpdatePacket;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRequestRouterPacket;
import com.codinglitch.simpleradio.core.registry.menus.RadiosmitherMenu;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.util.TriConsumer;

public class SimpleRadioNetworking {
    public static void loadServerbound(ServerboundRegistry registry) {
        registry.register(ServerboundRadioUpdatePacket.ID, ServerboundRadioUpdatePacket.class, ServerboundRadioUpdatePacket::read, ServerboundRadioUpdatePacket::write, SimpleRadioNetworking::handleRadioUpdate);
        registry.register(ServerboundRequestRouterPacket.ID, ServerboundRequestRouterPacket.class, ServerboundRequestRouterPacket::read, ServerboundRequestRouterPacket::write, SimpleRadioNetworking::handleRequestRouter);
    }

    public static void loadClientbound(ClientboundRegistry registry) {
        registry.register(ClientboundActivityPacket.ID, ClientboundActivityPacket.class, ClientboundActivityPacket::read, ClientboundActivityPacket::write, SimpleRadioClientNetworking::handleActivityPacket);
        registry.register(ClientboundRegisterRouterPacket.ID, ClientboundRegisterRouterPacket.class, ClientboundRegisterRouterPacket::read, ClientboundRegisterRouterPacket::write, SimpleRadioClientNetworking::handleRegisterRouter);
        registry.register(ClientboundSpeakSoundPacket.ID, ClientboundSpeakSoundPacket.class, ClientboundSpeakSoundPacket::read, ClientboundSpeakSoundPacket::write, SimpleRadioClientNetworking::handleSpeakSound);
        registry.register(ClientboundWireEffectPacket.ID, ClientboundWireEffectPacket.class, ClientboundWireEffectPacket::read, ClientboundWireEffectPacket::write, SimpleRadioClientNetworking::handleWireEffect);
    }

    public static void handleRadioUpdate(ServerboundRadioUpdatePacket packet, MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            if (!Frequency.check(packet.frequency())) {
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof RadiosmitherMenu) {
                RadiosmitherMenu radiosmitherMenu = (RadiosmitherMenu)menu;
                if (!player.f_36096_.m_6875_((Player)player)) {
                    CommonSimpleRadio.debug("Player {} interacted with invalid menu {}", player, player.f_36096_);
                    return;
                }
                radiosmitherMenu.updateTinkering(packet.frequency(), packet.modulation());
            }
        });
    }

    public static void handleRequestRouter(ServerboundRequestRouterPacket packet, MinecraftServer server, ServerPlayer player) {
        UUID reference = packet.reference();
        String type = packet.type();
        short mapping = packet.mapping();
        server.execute(() -> {
            short identifier = RadioManager.getIdentifier(r -> reference.equals(r.reference) && r.getClass().getSimpleName().equals(type));
            if (identifier == Short.MAX_VALUE) {
                CommonSimpleRadio.warn("We could not find the {} with reference {} for mapping {}!", type, reference, mapping);
                return;
            }
            Services.NETWORKING.sendToPlayer(player, new ClientboundRegisterRouterPacket(mapping, identifier));
        });
    }

    public static interface ServerboundRegistry {
        public <P extends CustomPacket> void register(ResourceLocation var1, Class<P> var2, FriendlyByteBuf.Reader<P> var3, BiConsumer<P, FriendlyByteBuf> var4, TriConsumer<P, MinecraftServer, ServerPlayer> var5);
    }

    public static interface ClientboundRegistry {
        public <P extends CustomPacket> void register(ResourceLocation var1, Class<P> var2, FriendlyByteBuf.Reader<P> var3, BiConsumer<P, FriendlyByteBuf> var4, Consumer<P> var5);
    }
}

