/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import someassemblyrequired.block.SandwichBlockEntity;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModBlockEntityTypes;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)16);
    private static final VoxelShape[] SHAPES = SandwichBlock.createShapes();

    public SandwichBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    private static VoxelShape[] createShapes() {
        VoxelShape[] result = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)(i + 1), (double)12.0);
        }
        return result;
    }

    public static ItemStack createSandwich(BlockEntity blockEntity) {
        if (!(blockEntity instanceof SandwichBlockEntity)) {
            return ItemStack.f_41583_;
        }
        SandwichBlockEntity sandwichAssemblyTable = (SandwichBlockEntity)blockEntity;
        ItemStack sandwich = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        sandwichAssemblyTable.m_183515_(sandwich.m_41698_("BlockEntityTag"));
        return sandwich;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{SIZE});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int size = SandwichItemHandler.get((ICapabilityProvider)context.m_43722_()).map(SandwichBlock::getSizeFromSandwich).orElse(1);
        boolean isWaterLogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(isWaterLogged))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size));
    }

    public static int getSizeFromSandwich(SandwichItemHandler sandwich) {
        int size = Math.min(32, Math.max(2, sandwich.getTotalHeight())) + 1;
        return size / 2;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.m_8055_(pos.m_7495_()).m_204336_(ModTags.SANDWICHING_STATIONS)) {
            return level.m_141902_(pos, (BlockEntityType)ModBlockEntityTypes.SANDWICH.get()).map(blockEntity -> blockEntity.interact(player, hand)).orElse(InteractionResult.FAIL);
        }
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, builder));
        SandwichItemHandler.get((ICapabilityProvider)builder.m_287159_(LootContextParams.f_81462_)).map(sandwich -> {
            if (sandwich.getItemCount() != 1) {
                return sandwich.getAsItem();
            }
            return sandwich.getStackInSlot(0);
        }).ifPresent(drops::add);
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return SandwichBlock.createSandwich(world.m_7702_(pos));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)SIZE) - 1];
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SandwichBlockEntity(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return SandwichBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }
}

