/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Carrier;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Spitter;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.HowlerVariants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Howler
extends EvolvedInfected
implements VariantKeeper,
ArmorPersentageBypass {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Spitter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Howler(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(2, (Goal)new HowlerAttackGoal(this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new BansheeMeleeGoal((PathfinderMob)this, this.f_19796_));
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, true){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Howler.this.getVariant() == HowlerVariants.DEFAULT;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.how_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.how_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public HowlerVariants getVariant() {
        return HowlerVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > HowlerVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return HowlerVariants.values().length;
    }

    private void setVariant(HowlerVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_howler_loot.get();
    }

    public void ScreamAOE(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(12.0);
        List targets = origin.m_9236_().m_6249_(origin, area, EntitySelector.f_20406_);
        for (Entity target : targets) {
            if (target instanceof Infected) {
                Infected infected = (Infected)target;
                infected.m_7292_(new MobEffectInstance((MobEffect)Seffects.MARKER.get(), 400, 0));
                continue;
            }
            if (!(target instanceof Player)) continue;
            Player player = (Player)target;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
        }
    }

    public void ScreamBuffInfected(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(6.0);
        List allies = origin.m_9236_().m_45933_(origin, area);
        int duration = switch (origin.m_9236_().m_46791_()) {
            case Difficulty.EASY -> 100;
            case Difficulty.NORMAL -> 200;
            case Difficulty.HARD -> 400;
            default -> 0;
        };
        int amplifier = origin.m_9236_().m_46791_() == Difficulty.HARD ? 1 : 0;
        List buffs = (List)SConfig.SERVER.howler_effects_buff.get();
        String randomBuff = (String)buffs.get(this.f_19796_.m_188503_(buffs.size()));
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(randomBuff));
        if (effect != null) {
            for (Entity ally : allies) {
                if (!(ally instanceof Infected)) continue;
                Infected infected = (Infected)ally;
                infected.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
        this.m_216990_((SoundEvent)Ssounds.HOWLER_GROWL.get());
    }

    public void SummonScream(LivingEntity caster) {
        Mob summoned;
        ServerLevelAccessor levelAccessor = (ServerLevelAccessor)caster.m_9236_();
        Level level = caster.m_9236_();
        int dx = this.f_19796_.m_216339_(-8, 9);
        int dz = this.f_19796_.m_216339_(-8, 9);
        int dy = this.f_19796_.m_216339_(0, 2);
        List summonPool = (List)SConfig.SERVER.howler_summon.get();
        String chosen = (String)summonPool.get(this.f_19796_.m_188503_(summonPool.size()));
        ResourceLocation entityId = new ResourceLocation(chosen);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        if (entityType != null && (summoned = (Mob)entityType.m_20615_(level)) != null) {
            summoned.m_246847_(caster.m_20185_() + (double)dx, caster.m_20186_() + 0.5 + (double)dy, caster.m_20189_() + (double)dz);
            summoned.m_6518_(levelAccessor, level.m_6436_(BlockPos.m_274446_((Position)caster.m_20182_())), MobSpawnType.NATURAL, null, null);
            level.m_7967_((Entity)summoned);
            this.m_216990_((SoundEvent)Ssounds.HOWLER_GROWL.get());
        }
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public boolean checkForInfected(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(4.0);
        List nearby = origin.m_9236_().m_6249_(origin, area, EntitySelector.f_20406_);
        for (Entity entity : nearby) {
            if (!(entity instanceof Infected) || ((List)SConfig.SERVER.support.get()).contains(entity.m_20078_()) || entity instanceof Carrier) continue;
            return true;
        }
        return false;
    }

    @Override
    public float amountOfDamage(float value) {
        return this.getVariant() == HowlerVariants.BANSHEE ? (float)((Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0) : 0.0f;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        this.setVariant(Math.random() < (double)0.2f ? HowlerVariants.BANSHEE : HowlerVariants.DEFAULT);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    private class HowlerAttackGoal
    extends Goal {
        private final Howler mob;
        private final double speed;
        private int screamTimer = 0;

        private HowlerAttackGoal(Howler mob, double speedModifier) {
            this.mob = mob;
            this.speed = speedModifier;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.getVariant() == HowlerVariants.DEFAULT;
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.screamTimer > 0) {
                --this.screamTimer;
            }
            if ((target = this.mob.m_5448_()) == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)target, 10.0f, (float)this.mob.m_8132_());
            double dist = this.mob.m_20280_((Entity)target);
            if (dist > 120.0) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speed);
            } else if (this.screamTimer <= 0) {
                if (Howler.this.checkForInfected((Entity)this.mob)) {
                    Howler.this.ScreamAOE((Entity)this.mob);
                    Howler.this.ScreamBuffInfected((Entity)this.mob);
                } else {
                    int summons = Howler.this.f_19796_.m_216339_(1, 3);
                    for (int i = 0; i < summons; ++i) {
                        Howler.this.SummonScream((LivingEntity)this.mob);
                    }
                }
                this.screamTimer = 120;
            }
        }
    }

    private static class BansheeMeleeGoal
    extends CustomMeleeAttackGoal {
        private int timeBeforeBigScream;
        private final RandomSource randomSource;

        public BansheeMeleeGoal(PathfinderMob mob, RandomSource randomSource) {
            super(mob, 1.75, true);
            this.randomSource = randomSource;
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.timeBeforeBigScream < 200) {
                ++this.timeBeforeBigScream;
            } else {
                this.callOrSummon();
                this.timeBeforeBigScream = 0;
                this.mob.m_216990_((SoundEvent)Ssounds.HOWLER_GROWL.get());
            }
        }

        public void callOrSummon() {
            List<Infected> brothers = this.getBrothers();
            if (brothers.isEmpty() || brothers.size() < 6) {
                Vec3 vec3 = Utilities.generatePositionAway(this.mob.m_20182_(), 16.0);
                for (int i = 0; i < this.randomSource.m_216339_(3, 10); ++i) {
                    this.summonAtDistance(vec3);
                }
            } else {
                for (Infected infected : brothers) {
                    if (!infected.m_6084_() || infected.m_5448_() != null) continue;
                    infected.m_6710_(this.mob.m_5448_());
                }
            }
        }

        public void summonAtDistance(Vec3 vec3) {
            Level level;
            Mob summoned;
            List summonPool = (List)SConfig.SERVER.howler_summon.get();
            String chosen = (String)summonPool.get(this.randomSource.m_188503_(summonPool.size()));
            ResourceLocation entityId = new ResourceLocation(chosen);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType != null && (summoned = (Mob)entityType.m_20615_(this.mob.m_9236_())) != null && (level = this.mob.m_9236_()) instanceof ServerLevelAccessor) {
                ServerLevelAccessor accessor = (ServerLevelAccessor)level;
                summoned.m_6021_(vec3.f_82479_, this.mob.m_20186_() + 0.5, vec3.f_82481_);
                summoned.m_6518_(accessor, accessor.m_6436_(BlockPos.m_274446_((Position)this.mob.m_20182_())), MobSpawnType.NATURAL, null, null);
                summoned.m_6710_(this.mob.m_5448_());
                accessor.m_7967_((Entity)summoned);
            }
        }

        public List<Infected> getBrothers() {
            return this.mob.m_9236_().m_45976_(Infected.class, this.mob.m_20191_().m_82377_(32.0, 8.0, 32.0));
        }

        @Override
        public boolean m_8036_() {
            Howler howler;
            PathfinderMob pathfinderMob;
            return super.m_8036_() && (pathfinderMob = this.mob) instanceof Howler && (howler = (Howler)pathfinderMob).getVariant() == HowlerVariants.BANSHEE;
        }
    }
}

