/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ServerBoundSetTextHolderPacket
implements Message {
    private final BlockPos pos;
    public final String[][] textHolderLines;

    public ServerBoundSetTextHolderPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.textHolderLines = new String[buf.m_130242_()][];
        for (int i = 0; i < this.textHolderLines.length; ++i) {
            String[] lines = new String[buf.m_130242_()];
            for (int j = 0; j < lines.length; ++j) {
                lines[j] = buf.m_130277_();
            }
            this.textHolderLines[i] = lines;
        }
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String[][] holderLines) {
        this.pos = pos;
        this.textHolderLines = holderLines;
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String[] lines) {
        this(pos, new String[][]{lines});
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String line) {
        this(pos, new String[]{line});
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.textHolderLines.length);
        for (String[] l : this.textHolderLines) {
            buf.m_130130_(l.length);
            for (String v : l) {
                buf.m_130070_(v);
            }
        }
    }

    public void handle(ChannelHandler.Context context) {
        Player player = context.getSender();
        if (player instanceof ServerPlayer) {
            ServerPlayer sender = (ServerPlayer)player;
            CompletableFuture.supplyAsync(() -> Stream.of(this.textHolderLines).map(line -> Stream.of(line).map(ChatFormatting::m_126649_).toList()).map(innerList -> sender.f_8906_.m_243065_(innerList)).map(CompletableFuture::join).toList()).thenAcceptAsync(l -> this.updateSignText(sender, (List<List<FilteredText>>)l), (Executor)sender.f_8924_);
        }
    }

    private void updateSignText(ServerPlayer player, List<List<FilteredText>> filteredText) {
        ITextHolderProvider te;
        BlockEntity blockEntity;
        player.m_9243_();
        Level level = player.m_9236_();
        if (level.m_46805_(this.pos) && (blockEntity = level.m_7702_(this.pos)) instanceof ITextHolderProvider && (te = (ITextHolderProvider)blockEntity).tryAcceptingClientText(this.pos, player, filteredText)) {
            BlockEntity be = (BlockEntity)te;
            be.m_6596_();
            level.m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        }
    }
}

