/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block.entity;

import com.mojang.authlib.GameProfile;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class TargetBlockEntity
extends BlockEntity
implements Nameable {
    public static final BlockEntityType<TargetBlockEntity> TYPE = BlockEntityType.Builder.m_155273_(TargetBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.TARGET.get()}).m_58966_(null);
    private static final int RESET_TIME = 100;
    private static final String OWNER_TAG = "Owner";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    public float rot = 0.0f;
    public float oRot = 0.0f;
    @Nullable
    private GameProfile owner;
    @Nullable
    private Component name;

    public TargetBlockEntity(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TargetBlockEntity pBlockEntity) {
        pBlockEntity.oRot = pBlockEntity.rot;
        pBlockEntity.rot = (Boolean)state.m_61143_((Property)TargetBlock.STAND) != false ? Math.max(pBlockEntity.rot - 18.0f, 0.0f) : Math.min(pBlockEntity.rot + 45.0f, 90.0f);
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
        SkullBlockEntity.m_155738_((GameProfile)this.owner, gameProfile -> {
            this.owner = gameProfile;
            this.refresh();
        });
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(OWNER_TAG, 10)) {
            this.owner = NbtUtils.m_129228_((CompoundTag)tag.m_128469_(OWNER_TAG));
        }
        if (tag.m_128425_(CUSTOM_NAME_TAG, 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME_TAG));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128365_(OWNER_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.owner));
        }
        if (this.name != null) {
            tag.m_128359_(CUSTOM_NAME_TAG, Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public Component m_7755_() {
        return this.name != null ? this.name : Component.m_237119_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-2, 0, -2), this.f_58858_.m_7918_(2, 2, 2));
    }

    public void hit(Level level, BlockState state, BlockHitResult hit, boolean isUpperBlock) {
        if (this.f_58857_ != null && ((Boolean)state.m_61143_((Property)TargetBlock.STAND)).booleanValue()) {
            BlockPos blockPos = hit.m_82425_();
            if (isUpperBlock) {
                blockPos = blockPos.m_7495_();
                state = level.m_8055_(blockPos);
            }
            int redstoneStrength = TargetBlock.getRedstoneStrength(hit, isUpperBlock);
            level.m_7731_(blockPos, (BlockState)((BlockState)state.m_61124_((Property)TargetBlock.STAND, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TargetBlock.OUTPUT_POWER, (Comparable)Integer.valueOf(redstoneStrength)), 3);
            level.m_186460_(blockPos, state.m_60734_(), 100);
            float volume = (float)((Integer)OtherConfig.TARGET_SOUND_DISTANCE.get()).intValue() / 16.0f;
            volume = Math.max(volume, 0.0f);
            level.m_5594_(null, blockPos, (SoundEvent)ModSounds.TARGET_HIT.get(), SoundSource.BLOCKS, volume, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

