/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.client.KeyConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.util.InputExtraCheck;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ReloadKey {
    public static final KeyMapping RELOAD_KEY = new KeyMapping("key.tacz.reload.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 82, "key.category.tacz");

    @SubscribeEvent
    public static void onReloadPress(InputEvent.Key event) {
        if (InputExtraCheck.isInGame() && event.getAction() == 1 && RELOAD_KEY.m_90832_(event.getKey(), event.getScanCode())) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || player.m_5833_()) {
                return;
            }
            Item item = player.m_21205_().m_41720_();
            if (item instanceof IGun) {
                IGun iGun = (IGun)item;
                if (iGun.useInventoryAmmo(player.m_21205_())) {
                    return;
                }
                IClientPlayerGunOperator.fromLocalPlayer(player).reload();
            }
        }
    }

    public static boolean onReloadControllerPress(boolean isPress) {
        if (InputExtraCheck.isInGame() && isPress) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || player.m_5833_()) {
                return false;
            }
            if (IGun.mainHandHoldGun((LivingEntity)player)) {
                IClientPlayerGunOperator.fromLocalPlayer(player).reload();
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void autoReload(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != LogicalSide.CLIENT) {
            return;
        }
        if (!((Boolean)KeyConfig.AUTO_RELOAD.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_() || player.f_19797_ % 5 != 0) {
            return;
        }
        ItemStack currentGunItem = player.m_21205_();
        Item item = player.m_21205_().m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            if (iGun.useInventoryAmmo(player.m_21205_())) {
                return;
            }
            boolean flag = TimelessAPI.getCommonGunIndex(iGun.getGunId(currentGunItem)).map(gunIndex -> gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT).orElse(false);
            int ammoCount = iGun.getCurrentAmmoCount(currentGunItem) + (iGun.hasBulletInBarrel(currentGunItem) && flag ? 1 : 0);
            if (ammoCount > 0) {
                return;
            }
            IClientPlayerGunOperator.fromLocalPlayer(player).reload();
        }
    }
}

