/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.animation.gltf.RawAnimationStructure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class GltfManager
extends SimplePreparableReloadListener<Map<ResourceLocation, AnimationStructure>> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"GltfAnimationLoader");
    private final Map<ResourceLocation, AnimationStructure> dataMap = Maps.newHashMap();
    private final FileToIdConverter filetoidconverter = new FileToIdConverter("animations", ".gltf");

    @NotNull
    protected Map<ResourceLocation, AnimationStructure> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : this.filetoidconverter.m_247457_(pResourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = this.filetoidconverter.m_245273_(resourcelocation);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    RawAnimationStructure rawStructure = (RawAnimationStructure)ClientAssetsManager.GSON.fromJson((Reader)reader, RawAnimationStructure.class);
                    AnimationStructure animationStructure = new AnimationStructure(rawStructure);
                    output.put(resourcelocation1, animationStructure);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read gltf animation file: {}", (Object)resourcelocation);
            }
        }
        return output;
    }

    protected void apply(Map<ResourceLocation, AnimationStructure> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dataMap.clear();
        this.dataMap.putAll(pObject);
    }

    public AnimationStructure getGltfAnimation(ResourceLocation id) {
        return this.dataMap.get(id);
    }
}

