/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.google.common.collect.Sets;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.util.HitboxHelper;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator DEFAULT_CONTEXT = new ExplosionDamageCalculator();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final float radius;
    private final boolean knockback;
    private final Entity owner;
    private final Entity exploder;
    private final ExplosionDamageCalculator damageCalculator;

    public ProjectileExplosion(Level level, Entity owner, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float power, float radius, boolean knockback, Explosion.BlockInteraction mode) {
        super(level, exploder, source, damageCalculator, x, y, z, radius, ((Boolean)AmmoConfig.EXPLOSIVE_AMMO_FIRE.get()).booleanValue(), mode);
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        this.radius = radius;
        this.owner = owner;
        this.exploder = exploder;
        this.damageCalculator = damageCalculator == null ? DEFAULT_CONTEXT : damageCalculator;
        this.knockback = knockback;
    }

    public void m_46061_() {
        this.level.m_142346_(this.exploder, GameEvent.f_157812_, BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z));
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int x = 0; x < i; ++x) {
            for (int y = 0; y < i; ++y) {
                block2: for (int z = 0; z < i; ++z) {
                    if (x != 0 && x != i - 1 && y != 0 && y != i - 1 && z != 0 && z != i - 1) continue;
                    double d0 = (float)x / (float)(i - 1) * 2.0f - 1.0f;
                    double d1 = (float)y / (float)(i - 1) * 2.0f - 1.0f;
                    double d2 = (float)z / (float)(i - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = BlockPos.m_274561_((double)blockX, (double)blockY, (double)blockZ);
                        BlockState blockState = this.level.m_8055_(pos);
                        FluidState fluidState = this.level.m_6425_(pos);
                        if (!this.level.m_46739_(pos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, pos, blockState, fluidState);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + f1) * f1;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)f1;
                        blockY += d1 * (double)f1;
                        blockZ += d2 * (double)f1;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float radius = this.radius;
        int minX = Mth.m_14107_((double)(this.x - (double)radius - 1.0));
        int maxX = Mth.m_14107_((double)(this.x + (double)radius + 1.0));
        int minY = Mth.m_14107_((double)(this.y - (double)radius - 1.0));
        int maxY = Mth.m_14107_((double)(this.y + (double)radius + 1.0));
        int minZ = Mth.m_14107_((double)(this.z - (double)radius - 1.0));
        int maxZ = Mth.m_14107_((double)(this.z + (double)radius + 1.0));
        List entities = this.level.m_45933_(this.exploder, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)entities, (double)(radius *= 2.0f));
        Vec3 explosionPos = new Vec3(this.x, this.y, this.z);
        for (Entity entity : entities) {
            Player player;
            double deltaZ;
            double deltaY;
            double deltaX;
            double strength;
            if (entity.m_6128_()) continue;
            AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.owner);
            double minDistance = radius;
            Vec3[] d = new Vec3[15];
            if (!(entity instanceof LivingEntity)) {
                strength = Math.sqrt(entity.m_20238_(explosionPos)) * 2.0 / (double)radius;
                deltaX = entity.m_20185_() - this.x;
                deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y;
                deltaZ = entity.m_20189_() - this.z;
            } else {
                deltaX = (boundingBox.f_82291_ + boundingBox.f_82288_) / 2.0;
                deltaY = (boundingBox.f_82292_ + boundingBox.f_82289_) / 2.0;
                deltaZ = (boundingBox.f_82293_ + boundingBox.f_82290_) / 2.0;
                d[0] = new Vec3(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
                d[1] = new Vec3(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82293_);
                d[2] = new Vec3(boundingBox.f_82288_, boundingBox.f_82292_, boundingBox.f_82290_);
                d[3] = new Vec3(boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82290_);
                d[4] = new Vec3(boundingBox.f_82288_, boundingBox.f_82292_, boundingBox.f_82293_);
                d[5] = new Vec3(boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82293_);
                d[6] = new Vec3(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82290_);
                d[7] = new Vec3(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
                d[8] = new Vec3(boundingBox.f_82288_, deltaY, deltaZ);
                d[9] = new Vec3(boundingBox.f_82291_, deltaY, deltaZ);
                d[10] = new Vec3(deltaX, boundingBox.f_82289_, deltaZ);
                d[11] = new Vec3(deltaX, boundingBox.f_82292_, deltaZ);
                d[12] = new Vec3(deltaX, deltaY, boundingBox.f_82290_);
                d[13] = new Vec3(deltaX, deltaY, boundingBox.f_82293_);
                d[14] = new Vec3(deltaX, deltaY, deltaZ);
                for (int s = 0; s < 15; ++s) {
                    BlockHitResult result = BlockRayTrace.rayTraceBlocks(this.level, new ClipContext(explosionPos, d[s], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                    minDistance = result.m_6662_() != HitResult.Type.BLOCK ? Math.min(minDistance, explosionPos.m_82554_(d[s])) : minDistance;
                }
                strength = minDistance * 2.0 / (double)radius;
                deltaX -= this.x;
                deltaY -= this.y;
                deltaZ -= this.z;
            }
            if (strength > 1.0) continue;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            }
            double damage = 1.0 - strength;
            entity.m_6469_(this.m_46077_(), (float)damage * this.power);
            if (entity instanceof LivingEntity) {
                damage = (float)ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)damage);
            }
            float multiplier = this.power * radius / 500.0f;
            if (!((Boolean)AmmoConfig.EXPLOSIVE_AMMO_KNOCK_BACK.get()).booleanValue() || !this.knockback) continue;
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
        }
    }
}

