/*
 * Decompiled with CFR 0.152.
 */
package com.mira.taczammoquery;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AmmoQueryEntry {
    private final ItemStack ammoStack;
    private final ResourceLocation ammoId;
    private List<ItemStack> allowGunStacks;
    private List<ItemStack> extraAllowGunStacks;

    public AmmoQueryEntry(ResourceLocation ammoId) {
        this.ammoStack = AmmoItemBuilder.create().setId(ammoId).build();
        this.ammoId = ammoId;
        this.allowGunStacks = Lists.newArrayList();
        this.extraAllowGunStacks = Lists.newArrayList();
        this.addAllAllowGuns();
        this.dividedGuns();
    }

    public static List<AmmoQueryEntry> getAllAmmoQueryEntries() {
        ArrayList entries = Lists.newArrayList();
        TimelessAPI.getAllCommonAmmoIndex().forEach(entry -> {
            AmmoQueryEntry queryEntry = new AmmoQueryEntry((ResourceLocation)entry.getKey());
            if (!queryEntry.getAllowGunStacks().isEmpty()) {
                entries.add(queryEntry);
            }
        });
        return entries;
    }

    public ItemStack getAttachmentStack() {
        return this.ammoStack;
    }

    public List<ItemStack> getAllowGunStacks() {
        return this.allowGunStacks;
    }

    public List<ItemStack> getExtraAllowGunStacks() {
        return this.extraAllowGunStacks;
    }

    private void addAllAllowGuns() {
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            ItemStack gun = GunItemBuilder.create().setId((ResourceLocation)entry.getKey()).build();
            Item patt2144$temp = gun.m_41720_();
            if (!(patt2144$temp instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)patt2144$temp;
            if (index.getGunData().getAmmoId().equals((Object)this.ammoId)) {
                this.allowGunStacks.add(gun);
            }
        });
        TimelessAPI.getCommonGunIndex(null).ifPresent(index -> {});
    }

    private void dividedGuns() {
        int size = this.allowGunStacks.size();
        if (size >= 60) {
            this.extraAllowGunStacks = this.allowGunStacks.subList(60, size);
            this.allowGunStacks = this.allowGunStacks.subList(0, 60);
        }
    }
}

