/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;

public class VatBlock
extends Block
implements IWrenchable,
IBE<VatBlockEntity> {
    public final String vatType;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public static VatBlock steel(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:steel_vat");
    }

    public static VatBlock cast_iron(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:cast_iron_vat");
    }

    public static VatBlock fireproof(BlockBehaviour.Properties properties) {
        return new VatBlock(properties, "tfmg:firebrick_lined_vat");
    }

    public VatBlock(BlockBehaviour.Properties properties, String vatType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_(SHAPE, (Comparable)((Object)Shape.PLAIN)));
        this.vatType = vatType;
    }

    public static boolean isVat(BlockState state) {
        return state.m_60734_() instanceof VatBlock;
    }

    public static void updateVatState(BlockState pState, Level pLevel, BlockPos tankPos) {
        BlockState tankState = pLevel.m_8055_(tankPos);
        Block block = tankState.m_60734_();
        if (!(block instanceof VatBlock)) {
            return;
        }
        VatBlock tank = (VatBlock)block;
        VatBlockEntity vatBE = (VatBlockEntity)tank.getBlockEntity((BlockGetter)pLevel, tankPos);
        if (vatBE == null) {
            return;
        }
        vatBE.evaluateNextTick = true;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, VatBlockEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        VatBlockEntity vatAt = (VatBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (vatAt == null) {
            return 0;
        }
        VatBlockEntity controllerTE = vatAt.getControllerBE();
        if (controllerTE == null || !controllerTE.window) {
            return 0;
        }
        return vatAt.luminosity;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), VatBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.m_82749_()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.m_60808_(pLevel, pPos);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof VatBlockEntity)) {
                return;
            }
            VatBlockEntity tankBE = (VatBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<VatBlockEntity> getBlockEntityClass() {
        return VatBlockEntity.class;
    }

    public BlockEntityType<? extends VatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.CHEMICAL_VAT.get();
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String m_7912_() {
            return CreateLang.asId((String)this.name());
        }
    }
}

