/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class VatItem
extends BlockItem {
    String vatType;

    public VatItem(Block block, Item.Properties properties, String vatType) {
        super(block, properties);
        this.vatType = vatType;
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            nbt.m_128473_("Luminosity");
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        Block block = placedOnState.m_60734_();
        if (!(block instanceof VatBlock)) {
            return;
        }
        VatBlock placedOnVat = (VatBlock)block;
        if (!placedOnVat.vatType.equals(this.vatType)) {
            return;
        }
        VatBlockEntity vatAt = (VatBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)TFMGBlockEntities.CHEMICAL_VAT.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (vatAt == null) {
            return;
        }
        VatBlockEntity controllerTE = vatAt.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        int width = controllerTE.getWidth();
        if (width == 1) {
            return;
        }
        int vatsToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerTE.m_58899_().m_7495_() : controllerTE.m_58899_().m_6630_(controllerTE.getHeight());
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (VatBlock.isVat(blockState)) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++vatsToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < vatsToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (VatBlock.isVat(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }

    public static class FireproofVatItem
    extends VatItem {
        public FireproofVatItem(Block block, Item.Properties properties) {
            super(block, properties, "tfmg:firebrick_lined_vat");
        }
    }

    public static class CastIronVatItem
    extends VatItem {
        public CastIronVatItem(Block block, Item.Properties properties) {
            super(block, properties, "tfmg:cast_iron_vat");
        }
    }

    public static class SteelVatItem
    extends VatItem {
        public SteelVatItem(Block block, Item.Properties properties) {
            super(block, properties, "tfmg:steel_vat");
        }
    }
}

