/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ClearCommand {
    public ClearCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(source -> ClearCommand.removeBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(source -> ClearCommand.removeBackpack((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"player")))));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(source -> ClearCommand.clearBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(source -> ClearCommand.clearBackpack((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"player")))));
        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(CommandSourceStack source, ServerPlayer player) {
        if (CapabilityUtils.isWearingBackpack((Player)player)) {
            if (TravelersBackpack.enableIntegration()) {
                return -1;
            }
            CapabilityUtils.getCapability((Player)player).ifPresent(data -> {
                if (!player.m_36356_(data.getBackpack().m_41777_())) {
                    player.m_36176_(data.getBackpack().m_41777_(), true);
                }
                data.equipBackpack(ItemStack.f_41583_);
                data.synchronise();
            });
            source.m_288197_(() -> Component.m_237113_((String)("Removed Traveler's Backpack from " + player.m_5446_().getString() + " and added copy to inventory")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + player.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }

    private static int clearBackpack(CommandSourceStack source, ServerPlayer player) {
        if (CapabilityUtils.isWearingBackpack((Player)player)) {
            if (TravelersBackpack.enableIntegration()) {
                return -1;
            }
            CapabilityUtils.getCapability((Player)player).ifPresent(data -> {
                ItemStack stack = data.getBackpack().m_41777_();
                if (!player.m_36356_(stack.m_41777_())) {
                    player.m_36176_(stack.m_41777_(), true);
                }
                int tier = NbtHelper.getOrDefault(stack, "Tier", 0);
                ItemStack clearedStack = stack.m_41720_().m_7968_();
                NbtHelper.set(clearedStack, "Tier", tier);
                data.equipBackpack(clearedStack);
                data.synchronise();
            });
            source.m_288197_(() -> Component.m_237113_((String)("Cleared contents of Traveler's Backpack from " + player.m_5446_().getString() + " and added copy to inventory")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + player.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }
}

