/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AutoPickupUpgrade
extends FilterUpgradeBase<AutoPickupUpgrade, AutoPickupFilterSettings>
implements IEnable {
    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 103), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get(), filter, filterTags);
    }

    public boolean canPickup(ItemStack stack) {
        return ((AutoPickupFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public AutoPickupFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.m_41619_()).toList(), this.getFilter(), filterTags);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get();
        if (this.isTagSelector()) {
            slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, 0, x + 64, y + 23, 1){

                @Override
                public boolean m_6659_() {
                    return super.m_6659_();
                }

                @Override
                public boolean m_5857_(ItemStack pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                }
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                        @Override
                        public boolean m_6659_() {
                            return super.m_6659_() && AutoPickupUpgrade.this.getFilter().get(0) != 2;
                        }

                        @Override
                        public boolean m_5857_(ItemStack pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    protected ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked("Inventory", AutoPickupUpgrade.this.filter);
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(AutoPickupUpgrade.this.getDataHolderStack(), "Inventory"));
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilterTags((List)NbtHelper.get(AutoPickupUpgrade.this.getDataHolderStack(), "FilterTags"));
                AutoPickupUpgrade.this.changeListeners.forEach(Runnable::run);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

