/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CoroUtilColor;
import com.corosus.coroutil.util.CoroUtilMisc;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;

public class ParticleTexLeafColor
extends ParticleTexFX {
    private static BlockColors colors;
    private static ConcurrentHashMap<BlockState, int[]> colorCache;
    public float rotationYawMomentum;
    public float rotationPitchMomentum;

    public ParticleTexLeafColor(ClientLevel worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, TextureAtlasSprite par8Item) {
        super(worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, par8Item);
        if (colors == null) {
            colors = Minecraft.m_91087_().m_91298_();
        }
        BlockPos pos = new BlockPos((int)Math.floor(posXIn), (int)Math.floor(posYIn), (int)Math.floor(posZIn));
        BlockState state = worldIn.m_8055_(pos);
        int multiplier = colors.m_92577_(state, (BlockAndTintGetter)this.f_107208_, pos, 0);
        int[] colors = colorCache.get(state);
        if (colors == null) {
            colors = CoroUtilColor.getColors((BlockState)state);
            if (colors.length == 0) {
                if (!this.hasColor(state) || (multiplier & 0xFFFFFF) == 0xFFFFFF) {
                    multiplier = 5811761;
                }
                colors = new int[]{65280};
            }
            if (colors.length > 1) {
                while (colors[colors.length - 1] == colors[colors.length - 2]) {
                    colors = ArrayUtils.remove((int[])colors, (int)(colors.length - 1));
                }
            }
            colorCache.put(state, colors);
        }
        int randMax = 1 << colors.length - 1;
        int choice = 32 - Integer.numberOfLeadingZeros(CoroUtilMisc.random.nextInt(randMax));
        int color = colors[choice];
        float mr = (float)(multiplier >>> 16 & 0xFF) / 255.0f;
        float mg = (float)(multiplier >>> 8 & 0xFF) / 255.0f;
        float mb = (float)(multiplier & 0xFF) / 255.0f;
        this.f_107227_ *= (float)(color >> 16 & 0xFF) / 255.0f * mr;
        this.f_107228_ *= (float)(color >> 8 & 0xFF) / 255.0f * mg;
        this.f_107229_ *= (float)(color & 0xFF) / 255.0f * mb;
    }

    @Override
    public void m_5989_() {
        double speed;
        super.m_5989_();
        if (this.isCollidedVerticallyDownwards && this.f_107223_.m_188503_(10) == 0 && (speed = Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_)) > 0.07) {
            this.f_107216_ = 0.02 + this.f_107223_.m_188500_() * 0.03;
            this.f_107215_ *= 0.6;
            this.f_107217_ *= 0.6;
            this.rotationYawMomentum = 30.0f;
            this.rotationPitchMomentum = 30.0f;
        }
        if (this.rotationYawMomentum > 0.0f) {
            this.rotationYaw += this.rotationYawMomentum;
            this.rotationYawMomentum -= 1.5f;
            if (this.rotationYawMomentum < 0.0f) {
                this.rotationYawMomentum = 0.0f;
            }
        } else {
            this.rotationYawMomentum = (float)((double)this.rotationYawMomentum + this.f_107223_.m_188500_() * 30.0);
        }
        if (this.rotationPitchMomentum > 0.0f) {
            this.rotationPitch += this.rotationPitchMomentum;
            this.rotationPitchMomentum -= 1.5f;
            if (this.rotationPitchMomentum < 0.0f) {
                this.rotationPitchMomentum = 0.0f;
            }
        } else {
            this.rotationPitchMomentum = (float)((double)this.rotationPitchMomentum + this.f_107223_.m_188500_() * 30.0);
        }
    }

    private final boolean hasColor(BlockState state) {
        return false;
    }

    static {
        colorCache = new ConcurrentHashMap();
    }
}

