/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import java.util.List;
import net.minecraft.world.phys.Vec3;

public class WeatherUtilPhysics {
    public static boolean isInConvexShape(Vec3 test, List<Vec3> points) {
        boolean result = false;
        int i = 0;
        int j = points.size() - 1;
        while (i < points.size()) {
            Vec3 vecI = points.get(i);
            Vec3 vecJ = points.get(j);
            if (vecI.f_82481_ > test.f_82481_ != vecJ.f_82481_ > test.f_82481_ && test.f_82479_ < (vecJ.f_82479_ - vecI.f_82479_) * (test.f_82481_ - vecI.f_82481_) / (vecJ.f_82481_ - vecI.f_82481_) + vecI.f_82479_) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static double getDistanceToShape(Vec3 point, List<Vec3> points) {
        float closestDist1 = 9999.0f;
        float closestDist2 = 9999.0f;
        Vec3 closestPoint1 = null;
        Vec3 closestPoint2 = null;
        for (int i = 0; i < 2; ++i) {
            for (Vec3 pointTest : points) {
                double dist = pointTest.m_82554_(point);
                if (dist < (double)closestDist1) {
                    closestDist1 = (float)dist;
                    closestPoint1 = pointTest;
                    continue;
                }
                if (!(dist < (double)closestDist2) || pointTest == closestPoint1) continue;
                closestDist2 = (float)dist;
                closestPoint2 = pointTest;
            }
        }
        if (closestPoint1 == null || closestPoint2 == null) {
            return -1.0;
        }
        return WeatherUtilPhysics.distBetweenPointAndLine(point.f_82479_, point.f_82481_, closestPoint1.f_82479_, closestPoint1.f_82481_, closestPoint2.f_82479_, closestPoint2.f_82481_);
    }

    public static double distBetweenPointAndLine(double x, double y, double x1, double y1, double x2, double y2) {
        double AB = WeatherUtilPhysics.distBetween(x, y, x1, y1);
        double BC = WeatherUtilPhysics.distBetween(x1, y1, x2, y2);
        double AC = WeatherUtilPhysics.distBetween(x, y, x2, y2);
        double s = (AB + BC + AC) / 2.0;
        double area = Math.sqrt(s * (s - AB) * (s - BC) * (s - AC));
        double AD = 2.0 * area / BC;
        return AD;
    }

    public static double distBetween(double x, double y, double x1, double y1) {
        double xx = x1 - x;
        double yy = y1 - y;
        return Math.sqrt(xx * xx + yy * yy);
    }
}

