/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import com.corosus.coroutil.util.CoroUtilMisc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import weather2.PacketNBTFromServer;
import weather2.ServerWeatherProxy;
import weather2.Weather;
import weather2.WeatherBlocks;
import weather2.WeatherNetworking;
import weather2.config.ConfigMisc;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.config.ConfigStorm;
import weather2.config.WeatherUtilConfig;
import weather2.datatypes.StormState;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtilBlock;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;
import weather2.weathersystem.wind.WindManager;

public class WeatherManagerServer
extends WeatherManager {
    private final ServerLevel world;

    public WeatherManagerServer(ServerLevel world) {
        super((ResourceKey<Level>)world.m_46472_());
        this.world = world;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public void tick() {
        StormState sandstorm;
        super.tick();
        StormState snowstorm = ServerWeatherProxy.getSnowstormForEverywhere(this.world);
        if (snowstorm != null) {
            this.tickStormBlockBuildup(snowstorm, Blocks.f_50125_);
        }
        if ((sandstorm = ServerWeatherProxy.getSandstormForEverywhere(this.world)) != null) {
            this.tickStormBlockBuildup(sandstorm, (Block)WeatherBlocks.BLOCK_SAND_LAYER.get());
        }
        this.tickWeatherCoverage();
        if (this.world != null) {
            WindManager windMan = this.getWindManager();
            this.getStormObjects().stream().filter(wo -> this.world.m_46467_() % (long)wo.getUpdateRateForNetwork() == 0L).forEach(this::syncStormUpdate);
            if (this.world.m_46467_() % 60L == 0L) {
                this.syncWindUpdate(windMan);
            }
            int rate = 20;
            if (this.world.m_46467_() % (long)rate == 0L) {
                for (int i = 0; i < this.getStormObjects().size(); ++i) {
                    WeatherObject so = this.getStormObjects().get(i);
                    Player closestPlayer = this.world.m_5788_(so.posGround.f_82479_, so.posGround.f_82480_, so.posGround.f_82481_, (double)ConfigMisc.Misc_simBoxRadiusCutoff, EntitySelector.f_20402_);
                    if (so instanceof StormObject && ((StormObject)so).isPet() || ConfigMisc.Winter_Wonderland && so instanceof WeatherObjectParticleStorm && ((WeatherObjectParticleStorm)so).getType() == WeatherObjectParticleStorm.StormType.SNOWSTORM) continue;
                    if (closestPlayer == null || ConfigMisc.Aesthetic_Only_Mode) {
                        so.ticksSinceNoNearPlayer += rate;
                        if (so.ticksSinceNoNearPlayer <= 600 && !ConfigMisc.Aesthetic_Only_Mode) continue;
                        if (this.world.m_8795_(LivingEntity::m_6084_).size() == 0) {
                            Weather.dbg("removing distant storm: " + so.ID + ", running without players");
                        } else {
                            Weather.dbg("removing distant storm: " + so.ID);
                        }
                        this.removeStormObject(so.ID);
                        this.syncStormRemove(so);
                        continue;
                    }
                    so.ticksSinceNoNearPlayer = 0;
                }
                Random rand = new Random();
                boolean spawnClouds = true;
                if (spawnClouds && !Weather.isLoveTropicsInstalled() && !ConfigMisc.Aesthetic_Only_Mode && WeatherUtilConfig.shouldTickClouds(this.world.m_46472_().m_135782_().toString())) {
                    for (int i = 0; i < this.world.m_6907_().size(); ++i) {
                        Player entP = (Player)this.world.m_6907_().get(i);
                        if (this.getStormObjects().size() >= ConfigStorm.Storm_MaxPerPlayerPerLayer * this.world.m_6907_().size() || rand.nextInt(5) != 0) continue;
                        this.trySpawnStormCloudNearPlayerForLayer(entP, 0);
                    }
                }
            }
            if (!Weather.isLoveTropicsInstalled() && WeatherUtilConfig.listDimensionsStorms.contains(this.world.m_46472_().m_135782_().toString()) && this.world.m_46467_() % 200L == 0L && windMan.isHighWindEventActive()) {
                if (!ConfigSand.Storm_NoSandstorms) {
                    this.tryParticleStorm((Level)this.world, WeatherObjectParticleStorm.StormType.SANDSTORM);
                }
                if (!(ConfigSnow.Storm_NoSnowstorms || ConfigMisc.Aesthetic_Only_Mode && !ConfigMisc.Winter_Wonderland)) {
                    this.tryParticleStorm((Level)this.world, WeatherObjectParticleStorm.StormType.SNOWSTORM);
                }
            }
        }
    }

    public Optional<BlockPos> findWeatherDeflector(BlockPos pos, int range) {
        double closestDist = 3.4028234663852886E38;
        BlockPos closestPos = null;
        for (Map.Entry<Long, BlockPos> entrySet : this.getLookupWeatherBlockDamageDeflector().entrySet()) {
            double dist = pos.m_123331_((Vec3i)entrySet.getValue());
            if (!(dist < (double)(range * range)) || !(dist < closestDist)) continue;
            closestDist = dist;
            closestPos = entrySet.getValue();
        }
        if (closestPos != null) {
            return Optional.of(closestPos);
        }
        return Optional.empty();
    }

    public void tickStormBlockBuildup(StormState stormState, Block block) {
        int maxStack;
        Level world = this.getWorld();
        WindManager windMan = this.getWindManager();
        Random rand = CoroUtilMisc.random();
        float angle = windMan.getWindAngle(null);
        int rate = 1;
        if (stormState != null) {
            rate = stormState.getBuildupTickRate();
            maxStack = stormState.getMaxStackable();
        } else {
            maxStack = 4;
        }
        if (world.m_46467_() % (long)rate == 0L) {
            ArrayList list = Lists.newArrayList((Iterable)((ServerLevel)world).m_7726_().f_8325_.m_140416_());
            Collections.shuffle(list);
            list.forEach(p_241099_7_ -> {
                Optional optional = p_241099_7_.m_140026_().getNow(ChunkHolder.f_139997_).left();
                if (optional.isPresent()) {
                    for (int i = 0; i < 10; ++i) {
                        BlockPos blockPos = new BlockPos(((LevelChunk)optional.get()).m_7697_().f_45578_ * 16 + rand.nextInt(16), 0, ((LevelChunk)optional.get()).m_7697_().f_45579_ * 16 + rand.nextInt(16));
                        int y = WeatherUtilBlock.getPrecipitationHeightSafe(world, blockPos).m_123342_();
                        Vec3 pos = new Vec3((double)blockPos.m_123341_(), (double)y, (double)blockPos.m_123343_());
                        WeatherUtilBlock.fillAgainstWallSmoothly(world, pos, angle, 15.0f, 2.0f, block, maxStack);
                    }
                }
            });
        }
    }

    public void syncStormRemove(WeatherObject parStorm) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncStormRemove");
        parStorm.nbtSyncForClient();
        data.m_128365_("data", (Tag)parStorm.getNbtCache().getNewNBT());
        data.m_128469_("data").m_128379_("removed", true);
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void syncWindUpdate(WindManager parManager) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncWindUpdate");
        data.m_128365_("data", (Tag)parManager.nbtSyncForClient());
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void tickWeatherCoverage() {
        ServerLevel world = (ServerLevel)this.getWorld();
        if (world != null) {
            if (!ConfigMisc.overcastMode && ConfigMisc.lockServerWeatherMode != -1) {
                world.f_8549_.m_5565_(ConfigMisc.lockServerWeatherMode == 1);
                world.f_8549_.m_5557_(ConfigMisc.lockServerWeatherMode == 1);
            }
            if (ConfigStorm.preventServerThunderstorms && !ConfigMisc.Aesthetic_Only_Mode) {
                world.f_8549_.m_5557_(false);
            }
            if (world.m_46467_() % 40L == 0L) {
                this.isVanillaRainActiveOnServer = world.m_46471_();
                this.isVanillaThunderActiveOnServer = world.m_46470_();
                this.vanillaRainTimeOnServer = world.f_8549_.m_6531_();
                float minRain = 0.0f;
                float maxRain = 0.0f;
                if (world.m_46470_()) {
                    minRain = 0.3f;
                    maxRain = 1.0f;
                } else if (world.m_46471_()) {
                    minRain = 0.1f;
                    maxRain = 0.7f;
                }
                this.vanillaRainAmountOnServer = Math.max(minRain, Math.min(maxRain, this.vanillaRainAmountOnServer + (CoroUtilMisc.random().nextFloat() - CoroUtilMisc.random().nextFloat()) * 0.02f));
                this.syncWeatherVanilla();
            }
            if (world.m_46467_() % 400L == 0L) {
                // empty if block
            }
            if (world.m_46467_() % 200L == 0L) {
                Random rand = new Random();
                this.cloudIntensity += (float)(rand.nextDouble() * ConfigMisc.Cloud_Coverage_Random_Change_Amount - rand.nextDouble() * ConfigMisc.Cloud_Coverage_Random_Change_Amount);
                if (ConfigMisc.overcastMode && world.m_46471_()) {
                    this.cloudIntensity = 1.0f;
                } else if ((double)this.cloudIntensity < ConfigMisc.Cloud_Coverage_Min_Percent / 100.0) {
                    this.cloudIntensity = (float)ConfigMisc.Cloud_Coverage_Min_Percent / 100.0f;
                } else if ((double)this.cloudIntensity > ConfigMisc.Cloud_Coverage_Max_Percent / 100.0) {
                    this.cloudIntensity = (float)ConfigMisc.Cloud_Coverage_Max_Percent / 100.0f;
                }
                if (world.m_46467_() % 2000L == 0L) {
                    // empty if block
                }
            }
        }
    }

    public void tryParticleStorm(Level level, WeatherObjectParticleStorm.StormType type) {
        String stormString;
        int stormOdds = ConfigSand.Sandstorm_OddsTo1;
        int timeBetweenTicks = ConfigSand.Sandstorm_TimeBetweenInTicks;
        long lastStormTime = this.lastSandstormFormed;
        boolean useGlobalServerRate = ConfigSand.Sandstorm_UseGlobalServerRate;
        if (type == WeatherObjectParticleStorm.StormType.SNOWSTORM) {
            stormOdds = ConfigSnow.Snowstorm_OddsTo1;
            stormString = "lastSnowstormTime";
            useGlobalServerRate = ConfigSnow.Snowstorm_UseGlobalServerRate;
            lastStormTime = this.lastSnowstormFormed;
        } else {
            stormString = "lastSandstormTime";
        }
        if (stormOdds <= 0 || CoroUtilMisc.random().nextInt(stormOdds) == 0) {
            if (useGlobalServerRate) {
                Player entP;
                boolean stormMade;
                if ((lastStormTime == 0L || lastStormTime + (long)timeBetweenTicks < level.m_46467_()) && this.world.m_6907_().size() > 0 && (stormMade = this.trySpawnParticleStormNearPos(level, (entP = (Player)this.world.m_6907_().get(CoroUtilMisc.random().nextInt(this.world.m_6907_().size()))).m_20182_(), type))) {
                    if (type == WeatherObjectParticleStorm.StormType.SANDSTORM) {
                        this.lastSandstormFormed = this.world.m_46467_();
                    } else if (type == WeatherObjectParticleStorm.StormType.SNOWSTORM) {
                        this.lastSnowstormFormed = this.world.m_46467_();
                    }
                }
            } else {
                this.world.m_6907_().stream().forEach(player -> {
                    boolean stormMade;
                    CompoundTag playerNBT = player.getPersistentData();
                    long lastStormTimePlayer = playerNBT.m_128454_(stormString);
                    if ((lastStormTimePlayer == 0L || lastStormTimePlayer + (long)timeBetweenTicks < level.m_46467_()) && (stormMade = this.trySpawnParticleStormNearPos(player.m_9236_(), player.m_20182_(), type))) {
                        playerNBT.m_128356_(stormString, this.world.m_46467_());
                    }
                });
            }
        }
    }

    public boolean trySpawnParticleStormNearPos(Level world, Vec3 posIn, WeatherObjectParticleStorm.StormType type) {
        return this.trySpawnParticleStormNearPos(world, posIn, type, false);
    }

    public boolean trySpawnParticleStormNearPos(Level world, Vec3 posIn, WeatherObjectParticleStorm.StormType type, boolean force) {
        int searchRadius = 64;
        double angle = this.getWindManager().getWindAngleForClouds();
        double dirX = -Math.sin(Math.toRadians(angle));
        double dirZ = Math.cos(Math.toRadians(angle));
        double vecX = dirX * (double)searchRadius / 2.0 * -1.0;
        double vecZ = dirZ * (double)searchRadius / 2.0 * -1.0;
        Random rand = new Random();
        BlockPos foundPos = null;
        int findTriesMax = 30;
        for (int i = 0; i < findTriesMax; ++i) {
            int zz;
            int xx;
            BlockPos posRight;
            int z;
            int x = Mth.m_14107_((double)(posIn.f_82479_ + vecX + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius));
            BlockPos pos = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(x, 0, z = Mth.m_14107_((double)(posIn.f_82481_ + vecZ + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius))));
            if (!world.m_46749_(pos)) continue;
            Biome biomeIn = (Biome)world.m_204166_(pos).get();
            if (!force && !WeatherObjectParticleStorm.canSpawnHere(world, pos, type, true)) continue;
            foundPos = pos;
            double dirXLeft = -Math.sin(Math.toRadians(angle - 90.0));
            double dirZLeft = Math.cos(Math.toRadians(angle - 90.0));
            double dirXRight = -Math.sin(Math.toRadians(angle + 90.0));
            double dirZRight = Math.cos(Math.toRadians(angle + 90.0));
            double distLeftRight = 20.0;
            BlockPos posLeft = WeatherUtilBlock.getPrecipitationHeightSafe(world, CoroUtilBlock.blockPos((double)((double)foundPos.m_123341_() + dirXLeft * distLeftRight), (double)0.0, (double)((double)foundPos.m_123343_() + dirZLeft * distLeftRight)));
            if (!world.m_46749_(posLeft) || !WeatherObjectParticleStorm.canSpawnHere(world, posLeft, type, false) || !world.m_46749_(posRight = WeatherUtilBlock.getPrecipitationHeightSafe(world, CoroUtilBlock.blockPos((double)((double)foundPos.m_123341_() + dirXRight * distLeftRight), (double)0.0, (double)((double)foundPos.m_123343_() + dirZRight * distLeftRight)))) || !WeatherObjectParticleStorm.canSpawnHere(world, posRight, type, false)) continue;
            BlockPos posFind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodUpwind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodDownwind = new BlockPos((Vec3i)foundPos);
            double tickDist = 10.0;
            while (world.m_46749_(posFind) && WeatherObjectParticleStorm.canSpawnHere(world, posFind, type, true)) {
                posFindLastGoodUpwind = new BlockPos((Vec3i)posFind);
                xx = Mth.m_14107_((double)((double)posFind.m_123341_() + dirX * -1.0 * tickDist));
                zz = Mth.m_14107_((double)((double)posFind.m_123343_() + dirZ * -1.0 * tickDist));
                posFind = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(xx, 0, zz));
            }
            posFind = new BlockPos((Vec3i)foundPos);
            while (world.m_46749_(posFind) && WeatherObjectParticleStorm.canSpawnHere(world, posFind, type, true)) {
                posFindLastGoodDownwind = new BlockPos((Vec3i)posFind);
                xx = Mth.m_14107_((double)((double)posFind.m_123341_() + dirX * 1.0 * tickDist));
                zz = Mth.m_14107_((double)((double)posFind.m_123343_() + dirZ * 1.0 * tickDist));
                posFind = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(xx, 0, zz));
            }
            int minDistanceOfDesertStretchNeeded = 20;
            double dist = posFindLastGoodUpwind.m_123331_((Vec3i)posFindLastGoodDownwind);
            if (!force && !(dist >= (double)(minDistanceOfDesertStretchNeeded * minDistanceOfDesertStretchNeeded))) continue;
            if (ConfigMisc.Winter_Wonderland && type == WeatherObjectParticleStorm.StormType.SNOWSTORM) {
                this.spawnParticleStorm(CoroUtilBlock.blockPos((Vec3)posIn), type);
            } else {
                this.spawnParticleStorm(posFindLastGoodUpwind, type);
            }
            Weather.dbg("found decent spot and stretch for particle storm, stretch: " + dist + ", type: " + type);
            return true;
        }
        Weather.dbg("couldnt spawn particle storm");
        return false;
    }

    public void spawnParticleStorm(BlockPos pos, WeatherObjectParticleStorm.StormType type) {
        WeatherObjectParticleStorm storm = new WeatherObjectParticleStorm(this);
        storm.setType(type);
        storm.initFirstTime();
        BlockPos posSpawn = new BlockPos((Vec3i)WeatherUtilBlock.getPrecipitationHeightSafe((Level)this.world, pos)).m_7494_();
        storm.initStormSpawn(new Vec3((double)posSpawn.m_123341_(), (double)posSpawn.m_123342_(), (double)posSpawn.m_123343_()));
        this.addStormObject(storm);
        this.syncStormNew(storm);
    }

    public void trySpawnStormCloudNearPlayerForLayer(Player entP, int layer) {
        Random rand = new Random();
        int tryCountMax = 10;
        int tryCountCur = 0;
        int spawnX = -1;
        int spawnZ = -1;
        Vec3 tryPos = null;
        StormObject soClose = null;
        Player playerClose = null;
        int closestToPlayer = 128;
        float windOffsetDist = Math.min(256, ConfigMisc.Misc_simBoxRadiusCutoff / 4 * 3);
        double angle = this.getWindManager().getWindAngleForClouds();
        double vecX = -Math.sin(Math.toRadians(angle)) * (double)windOffsetDist;
        double vecZ = Math.cos(Math.toRadians(angle)) * (double)windOffsetDist;
        while (tryCountCur++ == 0 || tryCountCur < tryCountMax && (soClose != null || playerClose != null)) {
            spawnX = (int)(entP.m_20185_() - vecX + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            spawnZ = (int)(entP.m_20189_() - vecZ + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            tryPos = new Vec3((double)spawnX, (double)StormObject.layers.get(layer).intValue(), (double)spawnZ);
            soClose = this.getClosestStormAny(tryPos, ConfigMisc.Cloud_Formation_MinDistBetweenSpawned);
            playerClose = entP.m_9236_().m_45924_((double)spawnX, 50.0, (double)spawnZ, (double)closestToPlayer, false);
        }
        if (soClose == null) {
            StormObject so = new StormObject(this);
            so.pos = tryPos;
            so.layer = layer;
            so.initFirstTime();
            if (layer != 0) {
                so.canBeDeadly = false;
            }
            so.spawnerUUID = entP.m_20149_();
            if (rand.nextFloat() >= this.cloudIntensity) {
                so.setCloudlessStorm(true);
            }
            this.addStormObject(so);
            this.syncStormNew(so);
        }
    }

    public void playerJoinedWorldSyncFull(ServerPlayer entP) {
        Weather.dbg("Weather2: playerJoinedWorldSyncFull for dim: " + this.dimension);
        Level world = this.getWorld();
        if (world != null) {
            Weather.dbg("Weather2: playerJoinedWorldSyncFull, sending " + this.getStormObjects().size() + " weather objects to: " + entP.m_7755_() + ", dim: " + this.dimension);
            for (int i = 0; i < this.getStormObjects().size(); ++i) {
                this.syncStormNew(this.getStormObjects().get(i), entP);
            }
        }
    }

    public void syncLightningNew(Entity parEnt, boolean custom) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncLightningNew");
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("posX", Mth.m_14107_((double)parEnt.m_20185_()));
        nbt.m_128405_("posY", Mth.m_14107_((double)parEnt.m_20186_()));
        nbt.m_128405_("posZ", Mth.m_14107_((double)parEnt.m_20189_()));
        nbt.m_128405_("entityID", parEnt.m_19879_());
        nbt.m_128379_("custom", custom);
        data.m_128365_("data", (Tag)nbt);
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void syncBlockParticleNew(BlockPos pos, BlockState state, WeatherObject owner) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncBlockParticleNew");
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("posX", pos.m_123341_());
        nbt.m_128405_("posY", pos.m_123342_());
        nbt.m_128405_("posZ", pos.m_123343_());
        nbt.m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)state));
        nbt.m_128356_("ownerID", owner.ID);
        data.m_128365_("data", (Tag)nbt);
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void syncStormNew(WeatherObject parStorm) {
        this.syncStormNew(parStorm, null);
    }

    public void syncStormNew(WeatherObject parStorm, @Nullable ServerPlayer entP) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncStormNew");
        CachedNBTTagCompound cache = parStorm.getNbtCache();
        cache.setUpdateForced(true);
        parStorm.nbtSyncForClient();
        cache.setUpdateForced(false);
        data.m_128365_("data", (Tag)cache.getNewNBT());
        if (entP == null) {
            WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
        } else {
            WeatherNetworking.HANDLER.sendTo((Object)new PacketNBTFromServer(data), entP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void syncStormUpdate(WeatherObject parStorm) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncStormUpdate");
        parStorm.getNbtCache().setNewNBT(new CompoundTag());
        parStorm.nbtSyncForClient();
        data.m_128365_("data", (Tag)parStorm.getNbtCache().getNewNBT());
        boolean testNetworkData = false;
        if (testNetworkData) {
            System.out.println("sending to client: " + parStorm.getNbtCache().getNewNBT().m_128431_().size());
            if (parStorm instanceof StormObject) {
                System.out.println("Real: " + ((StormObject)parStorm).levelCurIntensityStage);
                if (parStorm.getNbtCache().getNewNBT().m_128441_("levelCurIntensityStage")) {
                    System.out.println(" vs " + parStorm.getNbtCache().getNewNBT().m_128451_("levelCurIntensityStage"));
                } else {
                    System.out.println("no key!");
                }
            }
            Iterator iterator = parStorm.getNbtCache().getNewNBT().m_128431_().iterator();
            String keys = "";
            while (iterator.hasNext()) {
                keys = keys.concat((String)iterator.next() + "; ");
            }
            System.out.println("sending    " + keys);
        }
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void syncWeatherVanilla() {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "WeatherData");
        data.m_128359_("command", "syncWeatherUpdate");
        data.m_128379_("isVanillaRainActiveOnServer", this.isVanillaRainActiveOnServer);
        data.m_128379_("isVanillaThunderActiveOnServer", this.isVanillaThunderActiveOnServer);
        data.m_128405_("vanillaRainTimeOnServer", this.vanillaRainTimeOnServer);
        data.m_128350_("vanillaRainAmountOnServer", this.vanillaRainAmountOnServer);
        WeatherNetworking.HANDLER.send(PacketDistributor.DIMENSION.with(() -> this.getWorld().m_46472_()), (Object)new PacketNBTFromServer(data));
    }

    public void removeWeatherObjectAndSync(WeatherObject parStorm) {
        if (parStorm == null) {
            return;
        }
        if (this.getWorld().m_6907_().size() == 0) {
            Weather.dbg("removing distant storm: " + parStorm.ID + ", running without players");
        } else {
            Weather.dbg("removing distant storm: " + parStorm.ID);
        }
        this.removeStormObject(parStorm.ID);
        this.syncStormRemove(parStorm);
    }

    public void clearAllStorms() {
        for (WeatherObject so : this.getStormObjects()) {
            so.remove();
            this.syncStormRemove(so);
        }
        this.getStormObjects().clear();
        this.lookupStormObjectsByID.clear();
    }

    public float getBiomeBasedStormSpawnChanceInArea(BlockPos posCenter) {
        int scanResolution = 64;
        float samples = 0.0f;
        float allTemperaturesAdded = 0.0f;
        for (int x = -ConfigMisc.Misc_simBoxRadiusSpawn; x <= ConfigMisc.Misc_simBoxRadiusSpawn; x += scanResolution) {
            for (int z = -ConfigMisc.Misc_simBoxRadiusSpawn; z <= ConfigMisc.Misc_simBoxRadiusSpawn; z += scanResolution) {
                BlockPos pos = new BlockPos(posCenter.m_123341_() + x, posCenter.m_123342_(), posCenter.m_123343_() + z);
                if (!this.getWorld().m_46749_(pos)) continue;
                pos = WeatherUtilBlock.getPrecipitationHeightSafe(this.getWorld(), pos);
                Biome bgb = (Biome)this.getWorld().m_204166_(pos).get();
                allTemperaturesAdded += StormObject.getTemperatureMCToWeatherSys(CoroUtilCompatibility.getAdjustedTemperature((Level)this.getWorld(), (Biome)bgb, (BlockPos)pos));
                samples += 1.0f;
            }
        }
        CULog.dbg((String)("samples: " + samples));
        CULog.dbg((String)("allTemperaturesAdded: " + allTemperaturesAdded));
        float chance = 1.0f - Math.abs(allTemperaturesAdded) / samples;
        return chance;
    }
}

