/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.iceandfire.item;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.props.EntityDataProvider;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.magistuarmory.forge.item.MedievalWeaponItemForge;
import com.magistuarmory.iceandfire.item.IafItemTier;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyMedievalWeaponItem
extends MedievalWeaponItemForge {
    public AlchemyMedievalWeaponItem(Item.Properties properties, ModItemTier material, WeaponType type) {
        super(properties, material, type);
    }

    public boolean onHurtEntity(DamageSource source, LivingEntity victim, float damage) {
        float bonusdamage;
        Entity entity;
        if (ModDamageSources.isAdditional((DamageSource)source) || !((entity = source.m_7639_()) instanceof LivingEntity)) {
            return true;
        }
        LivingEntity attacker = (LivingEntity)entity;
        float maxDamage = this.getMaxDamage(attacker.m_21205_());
        float scale = damage / maxDamage;
        if (this.m_43314_() == IafItemTier.DRAGON_FIRE && IafConfig.dragonWeaponFireAbility) {
            if (victim instanceof EntityIceDragon) {
                bonusdamage = CombatHelper.getDamageAfterAbsorb((DamageSource)source, (LivingEntity)victim, (float)(scale * maxDamage / 1.5f));
                victim.m_6469_(attacker.m_9236_().m_269111_().m_269387_(), bonusdamage);
            }
            victim.m_20254_(5);
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        }
        if (this.m_43314_() == IafItemTier.DRAGON_ICE && IafConfig.dragonWeaponIceAbility) {
            if (victim instanceof EntityFireDragon) {
                bonusdamage = CombatHelper.getDamageAfterAbsorb((DamageSource)source, (LivingEntity)victim, (float)(scale * maxDamage / 1.5f));
                victim.m_6469_(attacker.m_9236_().m_269111_().m_269063_(), bonusdamage);
            }
            EntityDataProvider.getCapability((Entity)victim).ifPresent(data -> data.frozenData.setFrozen(victim, 200));
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2));
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        }
        if (this.m_43314_() == IafItemTier.DRAGON_LIGHTNING && IafConfig.dragonWeaponLightningAbility) {
            boolean flag = true;
            if (attacker instanceof Player && (double)attacker.f_20921_ > 0.2) {
                flag = false;
            }
            if (!attacker.m_9236_().f_46443_ && flag) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(victim.m_9236_());
                lightningboltentity.m_19880_().add(ServerEvents.BOLT_DONT_DESTROY_LOOT);
                lightningboltentity.m_19880_().add(attacker.m_20149_());
                lightningboltentity.m_20219_(victim.m_20182_());
                if (!victim.m_9236_().f_46443_) {
                    victim.m_9236_().m_7967_((Entity)lightningboltentity);
                }
            }
            if (victim instanceof EntityFireDragon || victim instanceof EntityIceDragon) {
                float bonusdamage2 = CombatHelper.getDamageAfterAbsorb((DamageSource)source, (LivingEntity)victim, (float)(scale * maxDamage / 3.0f));
                victim.m_6469_(attacker.m_9236_().m_269111_().m_269548_(), bonusdamage2);
            }
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        }
        return super.onHurtEntity(source, victim, damage);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.legendary_weapon.desc").m_130940_(ChatFormatting.GRAY));
        if (this == IafItemRegistry.DRAGONBONE_SWORD_FIRE.get()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_fire.hurt1").m_130940_(ChatFormatting.GREEN));
            if (IafConfig.dragonWeaponFireAbility) {
                tooltip.add((Component)Component.m_237115_((String)"dragon_sword_fire.hurt2").m_130940_(ChatFormatting.DARK_RED));
            }
        }
        if (this == IafItemRegistry.DRAGONBONE_SWORD_ICE.get()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_ice.hurt1").m_130940_(ChatFormatting.GREEN));
            if (IafConfig.dragonWeaponIceAbility) {
                tooltip.add((Component)Component.m_237115_((String)"dragon_sword_ice.hurt2").m_130940_(ChatFormatting.AQUA));
            }
        }
        if (this == IafItemRegistry.DRAGONBONE_SWORD_LIGHTNING.get()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_lightning.hurt1").m_130940_(ChatFormatting.GREEN));
            if (IafConfig.dragonWeaponLightningAbility) {
                tooltip.add((Component)Component.m_237115_((String)"dragon_sword_lightning.hurt2").m_130940_(ChatFormatting.DARK_PURPLE));
            }
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }
}

