/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.iceandfire.item;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.props.EntityDataProvider;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.magistuarmory.forge.item.MedievalWeaponItemForge;
import com.magistuarmory.iceandfire.item.IafItemTier;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.util.ModDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonSteelMedievalWeaponItem
extends MedievalWeaponItemForge {
    public DragonSteelMedievalWeaponItem(Item.Properties properties, ModItemTier material, WeaponType type) {
        super(properties, material, type);
    }

    public boolean onHurtEntity(DamageSource source, LivingEntity victim, float damage) {
        Entity entity;
        if (ModDamageSources.isAdditional((DamageSource)source) || !((entity = source.m_7639_()) instanceof LivingEntity)) {
            return true;
        }
        LivingEntity attacker = (LivingEntity)entity;
        float scale = damage / (float)this.getMaxDamage(attacker.m_21205_());
        if (this.m_43314_() == IafItemTier.DRAGONSTEEL_FIRE && IafConfig.dragonWeaponFireAbility) {
            victim.m_20254_(15);
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        } else if (this.m_43314_() == IafItemTier.DRAGONSTEEL_ICE && IafConfig.dragonWeaponIceAbility) {
            EntityDataProvider.getCapability((Entity)victim).ifPresent(data -> data.frozenData.setFrozen(victim, 300));
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 2));
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        } else if (this.m_43314_() == IafItemTier.DRAGONSTEEL_LIGHTNING && IafConfig.dragonWeaponLightningAbility) {
            boolean flag;
            boolean bl = flag = !(attacker instanceof Player) || !((double)attacker.f_20921_ > 0.2);
            if (!attacker.m_9236_().f_46443_ && flag) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(victim.m_9236_());
                lightningboltentity.m_19880_().add(ServerEvents.BOLT_DONT_DESTROY_LOOT);
                lightningboltentity.m_19880_().add(attacker.m_20149_());
                lightningboltentity.m_20219_(victim.m_20182_());
                if (!victim.m_9236_().f_46443_) {
                    victim.m_9236_().m_7967_((Entity)lightningboltentity);
                }
            }
            victim.m_147240_((double)scale * 1.0, attacker.m_20185_() - victim.m_20185_(), attacker.m_20189_() - victim.m_20189_());
        }
        return super.onHurtEntity(source, victim, damage);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.m_43314_() == IafItemTier.DRAGONSTEEL_FIRE && IafConfig.dragonWeaponFireAbility) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_fire.hurt2").m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.m_43314_() == IafItemTier.DRAGONSTEEL_ICE && IafConfig.dragonWeaponIceAbility) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_ice.hurt2").m_130940_(ChatFormatting.AQUA));
        }
        if (this.m_43314_() == IafItemTier.DRAGONSTEEL_LIGHTNING && IafConfig.dragonWeaponLightningAbility) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_lightning.hurt2").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int getMaxDamage(ItemStack stack) {
        return IafItemTier.isDragonSteel(this.m_43314_()) ? IafConfig.dragonsteelBaseDurability : this.m_43314_().m_6609_();
    }
}

