/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts_api.battle_arts_skills.active;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.forixaim.battle_arts_api.battle_arts_skills.BattleArtsSkillSlots;
import net.forixaim.battle_arts_api.battle_arts_skills.CoreAPIDataKeys;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public abstract class ActiveSkill
extends Skill {
    protected List<WeaponCategory> allowedWeapons = Lists.newArrayList();
    protected List<Map<AnimationProperty.AttackPhaseProperty<?>, Object>> properties = Lists.newArrayList();
    protected float manaConsumption;
    protected float meterUsage;
    protected float staminaConsumption;

    public ActiveSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.manaConsumption = parameters.m_128457_("mana_consumption");
        this.meterUsage = parameters.m_128457_("meter_usage");
        this.staminaConsumption = parameters.m_128457_("stamina_consumption");
    }

    protected boolean weaponCategoryMatch(WeaponCategory category) {
        for (WeaponCategory category1 : this.allowedWeapons) {
            if (category1 != category) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMeter(SkillContainer container) {
        if (container.getExecutor().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)CoreAPIDataKeys.METER_FILL.get())) {
            return ((Float)container.getExecutor().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)CoreAPIDataKeys.METER_FILL.get())).floatValue() >= this.meterUsage;
        }
        return this.meterUsage <= 0.0f;
    }

    public boolean canExecute(SkillContainer container) {
        ItemStack weapon = ((Player)container.getExecutor().getOriginal()).m_21205_();
        WeaponCategory weaponCategory = EpicFightCapabilities.getItemStackCapability((ItemStack)weapon).getWeaponCategory();
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        return super.canExecute(container) && this.weaponCategoryMatch(weaponCategory) && this.hasMeter(container) && ((Player)container.getExecutor().getOriginal()).m_20202_() == null && (!container.getExecutor().getSkill((Skill)this).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
    }

    private float consumeMeter(float data) {
        return data - this.meterUsage;
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch executor = (ServerPlayerPatch)playerPatch;
            executor.setStamina(executor.getStamina() - this.staminaConsumption);
        }
        if (this.hasMeter(container)) {
            container.getExecutor().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSyncF((SkillDataKey)CoreAPIDataKeys.METER_FILL.get(), this::consumeMeter);
        }
        super.executeOnServer(container, args);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
    }

    protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyKey, Map<AnimationProperty.AttackPhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyKey));
    }

    public ActiveSkill newProperty() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> ActiveSkill addProperty(AnimationProperty.AttackPhaseProperty<T> propertyKey, T object) {
        this.properties.get(this.properties.size() - 1).put(propertyKey, object);
        return this;
    }
}

