/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts_api.battle_arts_skills.battle_style;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.forixaim.battle_arts_api.Config;
import net.forixaim.battle_arts_api.battle_arts_skills.BattleArtsSkillCategories;
import net.forixaim.battle_arts_api.battle_arts_skills.CoreAPIDataKeys;
import net.forixaim.battle_arts_api.battle_arts_skills.battle_style.BattleStyleCategories;
import net.forixaim.battle_arts_api.battle_arts_skills.battle_style.BattleStyleCategory;
import net.forixaim.battle_arts_api.battle_arts_skills.passive.BattleStyleDependentPassive;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public abstract class BattleStyle
extends Skill {
    private static final UUID UNIVERSAL_BATTLE_STYLE_UUID = UUID.fromString("705bfb84-a7c1-4726-bc7b-36cbabb84843");
    protected float[] innateSkillColor = new float[]{0.0f, 0.64f, 0.72f};
    protected float[] innateInactiveColor = new float[]{0.5f, 0.5f, 0.5f};
    protected int proficiencyXpPerKill = 0;
    protected float jumpBoostPower = 0.0f;
    private static final ResourceLocation CONTAINER_TEX = ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/container.png");
    private static final ResourceLocation OVERLAY_TEX = ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/overlay.png");
    private static final List<ResourceLocation> BARS = Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_1.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_2.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_3.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_4.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_5.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_6.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_7.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_8.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_9.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_meter_10.png")});
    private static final List<ResourceLocation> METER_ICONS = Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_0.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_1.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_2.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_3.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_4.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_5.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_6.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_7.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_8.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_9.png"), ResourceLocation.fromNamespaceAndPath((String)"battlearts_api", (String)"textures/gui/meter/super_icon_10.png")});
    protected int maxMeter = 0;
    protected float criticalHitChance = 0.5f;
    protected float criticalHitDamage = 0.5f;
    protected List<ResourceKey<DamageType>> immuneDamages;
    protected List<TagKey<DamageType>> immuneModdedDamages;
    protected BattleStyleCategory category;
    protected List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> unarmedAttackAnimations = Lists.newArrayList();
    protected Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> unarmedLivingMotions = Maps.newHashMap();
    protected Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> unarmedBattleMotions = Maps.newHashMap();
    protected Map<GuardSkill, Map<GuardSkill.BlockType, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> guardMaps;
    protected Skill unarmedInnateSkill = null;
    protected Skill unarmedPassiveSkill = null;
    protected final List<Skill> dependentSkills;
    private final Map<Attribute, AttributeModifier> BattleStyleStatModifier = Maps.newHashMap();
    protected Map<WeaponCategory, AnimationManager.AnimationAccessor<? extends StaticAnimation>> weaponDrawAnimations;

    public static Builder<BattleStyle> CreateBattleStyle() {
        return new Builder().setCategory(BattleArtsSkillCategories.BATTLE_STYLE).setResource(Skill.Resource.NONE);
    }

    public SkillDataKey<Boolean> getSneakIsDisabledKey() {
        return null;
    }

    public BattleStyle(Builder<?> builder) {
        super(builder);
        this.immuneDamages = Lists.newArrayList();
        this.immuneModdedDamages = Lists.newArrayList();
        this.weaponDrawAnimations = Maps.newHashMap();
        this.dependentSkills = Lists.newArrayList();
        this.guardMaps = Maps.newHashMap();
        this.category = builder.battleStyleCategory;
    }

    public float[] getInnateInactiveColor() {
        return this.innateInactiveColor;
    }

    public Skill getUnarmedInnateSkill() {
        return this.unarmedInnateSkill;
    }

    public Map<GuardSkill, Map<GuardSkill.BlockType, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> getGuardMaps() {
        return this.guardMaps;
    }

    public boolean unarmedMoveset() {
        return false;
    }

    public Skill getUnarmedPassiveSkill() {
        return this.unarmedPassiveSkill;
    }

    public boolean modifiesUnarmedAttacks() {
        return this.unarmedAttackAnimations != null && !this.unarmedAttackAnimations.isEmpty();
    }

    public boolean modifiesUnarmedLMs() {
        return this.unarmedLivingMotions != null && !this.unarmedLivingMotions.isEmpty();
    }

    public boolean modifiesUnarmedBMs() {
        return this.unarmedBattleMotions != null && !this.unarmedBattleMotions.isEmpty();
    }

    public Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getUnarmedBattleMotions() {
        return this.unarmedBattleMotions;
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getUnarmedAttackAnimations() {
        return this.unarmedAttackAnimations;
    }

    public Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getUnarmedLivingMotions() {
        return this.unarmedLivingMotions;
    }

    public int getProficiencyBonus() {
        return this.proficiencyXpPerKill;
    }

    public static Builder<BattleStyle> createBattleStyleBuilder() {
        return new Builder().setCategory(BattleArtsSkillCategories.BATTLE_STYLE).setResource(Skill.Resource.NONE);
    }

    public List<ResourceKey<DamageType>> getImmuneDamages() {
        return this.immuneDamages;
    }

    public List<TagKey<DamageType>> getImmuneModdedDamages() {
        return this.immuneModdedDamages;
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        if (parameters.m_128441_("max_meter")) {
            this.maxMeter = parameters.m_128451_("max_meter");
        }
        this.BattleStyleStatModifier.clear();
        if (parameters.m_128441_("attribute_modifiers")) {
            ListTag attributeList = parameters.m_128437_("attribute_modifiers", 10);
            for (Tag tag : attributeList) {
                CompoundTag comp = (CompoundTag)tag;
                String attribute = comp.m_128461_("attribute");
                Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.parse((String)attribute));
                AttributeModifier modifier = ParseUtil.toAttributeModifier((CompoundTag)comp);
                this.BattleStyleStatModifier.put(attr, modifier);
            }
        }
        this.jumpBoostPower = parameters.m_128457_("jump_boost_power");
    }

    public float getJumpBoostPower() {
        return this.jumpBoostPower;
    }

    public float getCriticalHitDamage() {
        return this.criticalHitDamage;
    }

    public void onInitiate(SkillContainer container) {
        ServerPlayerPatch spp;
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof ServerPlayerPatch && !((spp = (ServerPlayerPatch)playerPatch).getHoldingItemCapability(InteractionHand.MAIN_HAND) instanceof WeaponCapability)) {
            spp.modifyLivingMotionByCurrentItem(false);
        }
        this.BattleStyleStatModifier.forEach((attribute, attributeModifier) -> {
            if (((Player)container.getExecutor().getOriginal()).m_21051_(attribute) != null && Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_21051_(attribute)).m_22109_(attributeModifier)) {
                Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_21051_(attribute)).m_22118_(attributeModifier);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, UNIVERSAL_BATTLE_STYLE_UUID, event -> {
            float random = ((Player)container.getExecutor().getOriginal()).m_217043_().m_188501_();
            CriticalHitEvent crit = ForgeHooks.getCriticalHit((Player)((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()), (Entity)event.getTarget(), (boolean)false, (float)(random <= this.criticalHitChance ? 1.0f + this.getCriticalHitDamage() : 1.0f));
            if (crit != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(SoundEvents.f_12313_, 1.0f, 1.0f);
            }
        });
    }

    public boolean shouldDraw(SkillContainer container) {
        return this.maxMeter > 0;
    }

    private void removeBattleStyleDependentSkills(ServerPlayerPatch playerPatch) {
        EpicFightNetworkManager.PayloadBundleBuilder toLocal = EpicFightNetworkManager.PayloadBundleBuilder.create();
        for (SkillContainer skillContainer : playerPatch.getSkillCapability().skillContainers) {
            BattleStyleDependentPassive bsd;
            Skill skill = skillContainer.getSkill();
            if (!(skill instanceof BattleStyleDependentPassive) || !(bsd = (BattleStyleDependentPassive)skill).isApplicable(this)) continue;
            skillContainer.setSkill(null);
            toLocal.and((Object)new SPChangeSkill((SkillSlot)SkillSlots.WEAPON_INNATE, ((ServerPlayer)playerPatch.getOriginal()).m_19879_(), (Skill)this));
        }
    }

    public void onRemoved(SkillContainer container) {
        ServerPlayerPatch spp;
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof ServerPlayerPatch && !((spp = (ServerPlayerPatch)playerPatch).getHoldingItemCapability(InteractionHand.MAIN_HAND) instanceof WeaponCapability)) {
            spp.modifyLivingMotionByCurrentItem(false);
            this.removeBattleStyleDependentSkills(spp);
        }
        this.BattleStyleStatModifier.forEach((attribute, attributeModifier) -> {
            if (((Player)container.getExecutor().getOriginal()).m_21051_(attribute) != null && Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_21051_(attribute)).m_22109_(attributeModifier)) {
                Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_21051_(attribute)).m_22130_(attributeModifier);
            }
        });
    }

    public Set<Map.Entry<Attribute, AttributeModifier>> getModfierEntry() {
        return this.BattleStyleStatModifier.entrySet();
    }

    public void updateContainer(SkillContainer container) {
        LocalPlayerPatch localPlayerPatch;
        super.updateContainer(container);
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof LocalPlayerPatch && (localPlayerPatch = (LocalPlayerPatch)playerPatch).isTargetLockedOn()) {
            container.getDataManager().setDataSync((SkillDataKey)CoreAPIDataKeys.COMBAT_COOLDOWN.get(), (Object)50);
        } else {
            container.getDataManager().setDataSyncF((SkillDataKey)CoreAPIDataKeys.COMBAT_COOLDOWN.get(), data -> data - 1);
        }
    }

    public int getMaxMeter() {
        return this.maxMeter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float pt) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float meterLevel = ((Float)container.getDataManager().getDataValue((SkillDataKey)CoreAPIDataKeys.METER_FILL.get())).floatValue();
        poseStack.m_85837_(Config.superMeterPositionX, Config.superMeterPositionY, 0.0);
        poseStack.m_85841_((float)Config.superMeterScaleX, (float)Config.superMeterScaleY, 1.0f);
        guiGraphics.m_280163_(CONTAINER_TEX, (int)x, (int)y, 0.0f, 0.0f, 128, 8, 128, 8);
        for (int i = Math.max(0, (int)meterLevel / 100 - 1); i < (int)meterLevel / 100 && i < 10; ++i) {
            ResourceLocation tex = BARS.get(Math.min(i, BARS.size() - 1));
            guiGraphics.m_280163_(tex, (int)x, (int)y, 0.0f, 0.0f, 128, 8, 128, 8);
        }
        if (meterLevel / 100.0f < (float)BARS.size() && meterLevel % 100.0f > 0.0f) {
            float percent = (float)((int)meterLevel % 100) / 100.0f;
            int filledWidth = (int)(128.0f * percent);
            ResourceLocation tex = BARS.get((int)Math.min(meterLevel / 100.0f, (float)(BARS.size() - 1)));
            guiGraphics.m_280163_(tex, (int)x, (int)y, 0.0f, 0.0f, filledWidth, 8, filledWidth, 8);
        }
        guiGraphics.m_280163_(OVERLAY_TEX, (int)x, (int)y, 0.0f, 0.0f, 128, 8, 128, 8);
        int iconIndex = (int)(meterLevel / 100.0f % (float)METER_ICONS.size());
        guiGraphics.m_280163_(METER_ICONS.get(iconIndex), (int)x - 32, (int)y - 12, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.m_85849_();
    }

    public float[] getInnateSkillColor() {
        return this.innateSkillColor;
    }

    private static /* synthetic */ Float lambda$updateContainer$3(Float data) {
        return Float.valueOf(data.floatValue() + 1.0f);
    }

    public static class Builder<T extends BattleStyle>
    extends SkillBuilder<BattleStyle> {
        protected BattleStyleCategory battleStyleCategory = BattleStyleCategories.STARTING;

        public Builder<T> setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder<T> setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder<T> setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder<T> setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder<T> setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder<T> setBattleStyleCategory(BattleStyleCategory category) {
            this.battleStyleCategory = category;
            return this;
        }
    }
}

