/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts_api.battle_arts_skills.passive;

import java.util.List;
import java.util.Map;
import net.forixaim.battle_arts_api.battle_arts_skills.BattleArtsSkillSlots;
import net.forixaim.battle_arts_api.battle_arts_skills.battle_style.BattleStyle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class BattleStyleDependentPassive
extends PassiveSkill {
    protected Map<Attribute, AttributeModifier> attributes;
    protected List<BattleStyle> battleStyles;

    public BattleStyleDependentPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public boolean isApplicable(BattleStyle style) {
        return this.battleStyles.contains((Object)style);
    }

    private boolean totalCheck(PlayerPatch<?> playerPatch) {
        BattleStyle style = (BattleStyle)playerPatch.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getSkill();
        return this.isApplicable(style);
    }

    public void onInitiate(SkillContainer container) {
        container.setMaxDuration(this.maxDuration);
        if (!this.totalCheck(container.getExecutor())) {
            for (Map.Entry<Attribute, AttributeModifier> attributeAttributeModifierEntry : this.attributes.entrySet()) {
                AttributeInstance attr = ((Player)container.getExecutor().getOriginal()).m_21051_(attributeAttributeModifierEntry.getKey());
                assert (attr != null);
                if (attr.m_22109_(attributeAttributeModifierEntry.getValue())) continue;
                attr.m_22118_(attributeAttributeModifierEntry.getValue());
            }
        }
    }

    public void setParams(CompoundTag parameters) {
        this.consumption = parameters.m_128457_("consumption");
        this.maxDuration = parameters.m_128451_("max_duration");
        this.maxStackSize = parameters.m_128441_("max_stacks") ? parameters.m_128451_("max_stacks") : 1;
        this.attributes.clear();
        if (parameters.m_128441_("attribute_modifiers")) {
            ListTag attributeList = parameters.m_128437_("attribute_modifiers", 10);
            for (Tag tag : attributeList) {
                CompoundTag comp = (CompoundTag)tag;
                String attribute = comp.m_128461_("attribute");
                Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.parse((String)attribute));
                AttributeModifier modifier = ParseUtil.toAttributeModifier((CompoundTag)comp);
                this.attributes.put(attr, modifier);
            }
        }
    }
}

