/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts_api.events;

import net.forixaim.battle_arts_api.battle_arts_skills.BattleArtsSkillSlots;
import net.forixaim.battle_arts_api.battle_arts_skills.battle_style.BattleStyle;
import net.forixaim.battle_arts_api.events.player.BattleArtsPlayerEvents;
import net.forixaim.battle_arts_api.events.player.EquipmentSwitchEvent;
import net.forixaim.battle_arts_api.events.player.PlayerDeathEvent;
import net.forixaim.battle_arts_api.events.player.PlayerReviveEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

@Mod.EventBusSubscriber(modid="battlearts_api")
public class WorldEvents {
    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        PlayerPatch player;
        Skill skill;
        EntityPatch entityPatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entityPatch instanceof PlayerPatch && (skill = (player = (PlayerPatch)entityPatch).getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getSkill()) instanceof BattleStyle) {
            BattleStyle bs = (BattleStyle)skill;
            Vec3 dM = ((Player)player.getOriginal()).m_20184_();
            event.getEntity().m_20334_(dM.f_82479_, dM.f_82480_ * (double)(1.0f + bs.getJumpBoostPower()), dM.f_82481_);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            ServerPlayerPatch serverPlayer = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            serverPlayer.getEventListener().triggerEvents(BattleArtsPlayerEvents.EQUIPMENT_SWITCH_EVENT, new EquipmentSwitchEvent<ServerPlayerPatch>(serverPlayer, false, event.getFrom(), event.getTo(), event.getSlot()));
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            ServerPlayerPatch serverPlayer = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            if (serverPlayer.getEventListener().triggerEvents(BattleArtsPlayerEvents.PLAYER_DEATH_EVENT, new PlayerDeathEvent<ServerPlayerPatch>(serverPlayer, event.getSource()))) {
                event.setCanceled(true);
                serverPlayer.getEventListener().triggerEvents(BattleArtsPlayerEvents.PLAYER_REVIVE_EVENT, new PlayerReviveEvent<ServerPlayerPatch>(serverPlayer));
            }
        }
    }
}

