/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.forge.network;

import com.cerbon.cerbons_api.api.network.PacketRegistrationHandler;
import com.cerbon.cerbons_api.api.network.data.PacketContainer;
import com.cerbon.cerbons_api.api.network.data.PacketContext;
import com.cerbon.cerbons_api.api.network.data.Side;
import com.cerbon.cerbons_api.util.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, SimpleChannel> CHANNELS = new HashMap();

    public ForgeNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.CHANNELS.get(container.messageType()) == null) {
            SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)container.packetIdentifier()).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
            channel.registerMessage(0, container.messageType(), container.encoder(), container.decoder(), this.buildHandler(container.handler()));
            Constants.LOGGER.debug("Registering packet {} : {} on the: {}", new Object[]{container.packetIdentifier(), container.messageType(), this.side});
            this.CHANNELS.put(container.messageType(), channel);
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = Minecraft.m_91087_().m_91403_().m_104910_()) || ignoreCheck) {
            channel.sendToServer(packet);
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = player.f_8906_.f_9742_)) {
            channel.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private <T> BiConsumer<T, Supplier<NetworkEvent.Context>> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgeNetworkHandler.lambda$buildHandler$3((Supplier)ctx, handler, message));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static /* synthetic */ void lambda$buildHandler$3(Supplier ctx, Consumer handler, Object message) {
        Side side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() ? Side.SERVER : Side.CLIENT;
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        handler.accept(new PacketContext<Object>(player, message, side));
    }
}

