/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.cofe_delight.common.block;

import club.someoneice.cofe_delight.common.block.BlockCup;
import club.someoneice.cofe_delight.init.BlockInit;
import club.someoneice.cofe_delight.util.CupType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCoffee
extends BlockCup {
    float saturation;
    CupType cap;
    @Nonnull
    MobEffect[] effects;
    int hunger;
    int time;
    int level;

    public BlockCoffee(int hunger, float saturation, CupType cap, @Nullable MobEffect[] effects, int time, int level) {
        this.hunger = hunger;
        this.saturation = saturation;
        this.cap = cap;
        this.effects = Objects.requireNonNullElse(effects, new MobEffect[0]);
        this.time = time;
        this.level = level;
    }

    public BlockCoffee(int hunger, float saturation, CupType cap) {
        this(hunger, saturation, cap, null, 0, 0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        player.m_5496_(SoundEvents.f_11970_, 0.4f, 0.7f);
        player.m_36324_().m_38707_(this.hunger, this.saturation);
        for (MobEffect effect : this.effects) {
            player.m_7292_(new MobEffectInstance(effect, this.time, this.level));
        }
        switch (this.cap) {
            case CUP: {
                world.m_46597_(pos, ((Block)BlockInit.COFFEE_CUP.get()).m_152465_(state));
                break;
            }
            case MUG: {
                world.m_46597_(pos, ((Block)BlockInit.COFFEE_MUG.get()).m_152465_(state));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

